/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.runtime.Execution;

public class ExecutionTree
implements Execution {
    protected List<ExecutionTree> children;
    protected Execution wrappedExecution;

    protected ExecutionTree(Execution execution, List<ExecutionTree> children) {
        this.wrappedExecution = execution;
        this.children = children;
    }

    public static ExecutionTree forExecution(final String executionId, ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = configuration.getCommandExecutorTxRequired();
        ExecutionTree executionTree = (ExecutionTree)commandExecutor.execute((Command)new Command<ExecutionTree>(){

            public ExecutionTree execute(CommandContext commandContext) {
                ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(executionId);
                return ExecutionTree.forExecution(execution);
            }
        });
        return executionTree;
    }

    protected static ExecutionTree forExecution(ExecutionEntity execution) {
        ArrayList<ExecutionTree> children = new ArrayList<ExecutionTree>();
        for (ExecutionEntity child : execution.getExecutions()) {
            children.add(ExecutionTree.forExecution(child));
        }
        return new ExecutionTree((Execution)execution, children);
    }

    public List<ExecutionTree> getExecutions() {
        return this.children;
    }

    public String getId() {
        return this.wrappedExecution.getId();
    }

    public boolean isSuspended() {
        return this.wrappedExecution.isSuspended();
    }

    public boolean isEnded() {
        return this.wrappedExecution.isEnded();
    }

    public String getProcessInstanceId() {
        return this.wrappedExecution.getProcessInstanceId();
    }

    public String getActivityId() {
        return ((PvmExecutionImpl)this.wrappedExecution).getActivityId();
    }

    public String toString() {
        return this.wrappedExecution.toString();
    }

    public Boolean isScope() {
        return ((PvmExecutionImpl)this.wrappedExecution).isScope();
    }

    public Boolean isConcurrent() {
        return ((PvmExecutionImpl)this.wrappedExecution).isConcurrent();
    }

    public Boolean isEventScope() {
        return ((PvmExecutionImpl)this.wrappedExecution).isEventScope();
    }

    public Execution getExecution() {
        return this.wrappedExecution;
    }
}

