/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.variables;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.core.variable.type.FileValueTypeImpl;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileValueTypeImplTest {
    private FileValueTypeImpl type;

    @Before
    public void setUp() {
        this.type = new FileValueTypeImpl();
    }

    @Test
    public void nameShouldBeFile() {
        Assert.assertThat((Object)this.type.getName(), (Matcher)CoreMatchers.is((Object)"file"));
    }

    @Test
    public void shouldNotHaveParent() {
        Assert.assertThat((Object)this.type.getParent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void isPrimitiveValue() {
        Assert.assertThat((Object)this.type.isPrimitiveValueType(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isNotAnAbstractType() {
        Assert.assertThat((Object)this.type.isAbstract(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void canNotConvertFromAnyValue() {
        Assert.assertThat((Object)this.type.canConvertFromTypedValue(null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=ProcessEngineException.class)
    public void convertingThrowsException() {
        this.type.convertFromTypedValue(Variables.untypedNullValue());
    }

    @Test
    public void createValueFromFile() throws URISyntaxException {
        File file = new File(this.getClass().getClassLoader().getResource("org/camunda/bpm/engine/test/variables/simpleFile.txt").toURI());
        TypedValue value = this.type.createValue((Object)file, Collections.singletonMap("filename", "simpleFile.txt"));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FileValue.class)));
        Assert.assertThat((Object)value.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FileValueTypeImpl.class)));
        this.checkStreamFromValue(value, "text");
    }

    @Test
    public void createValueFromStream() {
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        TypedValue value = this.type.createValue((Object)file, Collections.singletonMap("filename", "simpleFile.txt"));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FileValue.class)));
        Assert.assertThat((Object)value.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FileValueTypeImpl.class)));
        this.checkStreamFromValue(value, "text");
    }

    @Test
    public void createValueFromBytes() throws IOException, URISyntaxException {
        File file = new File(this.getClass().getClassLoader().getResource("org/camunda/bpm/engine/test/variables/simpleFile.txt").toURI());
        TypedValue value = this.type.createValue((Object)file, Collections.singletonMap("filename", "simpleFile.txt"));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FileValue.class)));
        Assert.assertThat((Object)value.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FileValueTypeImpl.class)));
        this.checkStreamFromValue(value, "text");
    }

    @Test
    public void createValueWithProperties() {
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("filename", "someFileName");
        properties.put("mimeType", "someMimeType");
        properties.put("encoding", "someEncoding");
        TypedValue value = this.type.createValue((Object)file, properties);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FileValue.class)));
        FileValue fileValue = (FileValue)value;
        Assert.assertThat((Object)fileValue.getFilename(), (Matcher)CoreMatchers.is((Object)"someFileName"));
        Assert.assertThat((Object)fileValue.getMimeType(), (Matcher)CoreMatchers.is((Object)"someMimeType"));
        Assert.assertThat((Object)fileValue.getEncoding(), (Matcher)CoreMatchers.is((Object)"someEncoding"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotCreateFileWithoutName() {
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        this.type.createValue((Object)file, Collections.emptyMap());
    }

    @Test
    public void valueInfoContainsFileTypeNameAndCharsetEncoding() {
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        String fileName = "simpleFile.txt";
        String fileType = "text/plain";
        Charset encoding = Charset.forName("UTF-8");
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file(file).mimeType(fileType).encoding(encoding).create();
        Map info = this.type.getValueInfo((TypedValue)fileValue);
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"filename", (Object)fileName));
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"mimeType", (Object)fileType));
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"encoding", (Object)encoding.name()));
    }

    @Test
    public void valueInfoContainsFileTypeNameAndStringEncoding() {
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        String fileName = "simpleFile.txt";
        String fileType = "text/plain";
        String encoding = "UTF-8";
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file(file).mimeType(fileType).encoding(encoding).create();
        Map info = this.type.getValueInfo((TypedValue)fileValue);
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"filename", (Object)fileName));
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"mimeType", (Object)fileType));
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"encoding", (Object)encoding));
    }

    @Test
    public void doesNotHaveParent() {
        Assert.assertThat((Object)this.type.getParent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void checkStreamFromValue(TypedValue value, String expected) {
        InputStream stream = (InputStream)value.getValue();
        Scanner scanner = new Scanner(stream);
        Assert.assertThat((Object)scanner.nextLine(), (Matcher)CoreMatchers.is((Object)expected));
    }
}

