/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.variables.serializer;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Scanner;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.core.variable.type.FileValueTypeImpl;
import org.camunda.bpm.engine.impl.core.variable.value.UntypedValueImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.serializer.FileValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileValueSerializerTest {
    private static final String SEPARATOR = "#";
    private FileValueSerializer serializer;

    @Before
    public void setUp() {
        this.serializer = new FileValueSerializer();
    }

    @Test
    public void testTypeIsFileValueType() {
        Assert.assertThat((Object)this.serializer.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FileValueTypeImpl.class)));
    }

    @Test
    public void testWriteFilenameOnlyValue() {
        String filename = "test.txt";
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assert.assertThat((Object)valueFields.getByteArrayValue().getBytes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)valueFields.getTextValue(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)valueFields.getTextValue2(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testWriteMimetypeAndFilenameValue() {
        String filename = "test.txt";
        String mimeType = "text/json";
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assert.assertThat((Object)valueFields.getByteArrayValue().getBytes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)valueFields.getTextValue(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)valueFields.getTextValue2(), (Matcher)CoreMatchers.is((Object)(mimeType + SEPARATOR)));
    }

    @Test
    public void testWriteMimetypeFilenameAndBytesValue() throws UnsupportedEncodingException {
        String filename = "test.txt";
        String mimeType = "text/json";
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).file(is).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assert.assertThat((Object)new String(valueFields.getByteArrayValue().getBytes(), "UTF-8"), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)valueFields.getTextValue(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)valueFields.getTextValue2(), (Matcher)CoreMatchers.is((Object)(mimeType + SEPARATOR)));
    }

    @Test
    public void testWriteMimetypeFilenameBytesValueAndEncoding() throws UnsupportedEncodingException {
        String filename = "test.txt";
        String mimeType = "text/json";
        Charset encoding = Charset.forName("UTF-8");
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).encoding(encoding).file(is).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assert.assertThat((Object)new String(valueFields.getByteArrayValue().getBytes(), "UTF-8"), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)valueFields.getTextValue(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)valueFields.getTextValue2(), (Matcher)CoreMatchers.is((Object)(mimeType + SEPARATOR + encoding.name())));
    }

    @Test
    public void testWriteMimetypeFilenameAndBytesValueWithShortcutMethod() throws URISyntaxException, UnsupportedEncodingException {
        File file = new File(this.getClass().getClassLoader().getResource("org/camunda/bpm/engine/test/variables/simpleFile.txt").toURI());
        FileValue fileValue = Variables.fileValue((File)file);
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assert.assertThat((Object)new String(valueFields.getByteArrayValue().getBytes(), "UTF-8"), (Matcher)CoreMatchers.is((Object)"text"));
        Assert.assertThat((Object)valueFields.getTextValue(), (Matcher)CoreMatchers.is((Object)"simpleFile.txt"));
        Assert.assertThat((Object)valueFields.getTextValue2(), (Matcher)CoreMatchers.is((Object)"text/plain#"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testThrowsExceptionWhenConvertingUnknownUntypedValueToTypedValue() {
        this.serializer.convertToTypedValue((UntypedValueImpl)Variables.untypedValue((Object)new Object()));
    }

    @Test
    public void testReadFileNameMimeTypeAndByteArray() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        byte[] data = new byte[is.available()];
        DataInputStream dataInputStream = new DataInputStream(is);
        dataInputStream.readFully(data);
        dataInputStream.close();
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        valueFields.setByteArrayValue(data);
        String mimeType = "text/plain";
        valueFields.setTextValue2(mimeType + SEPARATOR);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true);
        Assert.assertThat((Object)fileValue.getFilename(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)fileValue.getMimeType(), (Matcher)CoreMatchers.is((Object)mimeType));
        this.checkStreamFromValue((TypedValue)fileValue, "text");
    }

    @Test
    public void testReadFileNameEncodingAndByteArray() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        byte[] data = new byte[is.available()];
        DataInputStream dataInputStream = new DataInputStream(is);
        dataInputStream.readFully(data);
        dataInputStream.close();
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        valueFields.setByteArrayValue(data);
        String encoding = "#UTF-8";
        valueFields.setTextValue2(encoding);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true);
        Assert.assertThat((Object)fileValue.getFilename(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)fileValue.getEncoding(), (Matcher)CoreMatchers.is((Object)"UTF-8"));
        Assert.assertThat((Object)fileValue.getEncodingAsCharset(), (Matcher)CoreMatchers.is((Object)Charset.forName("UTF-8")));
        this.checkStreamFromValue((TypedValue)fileValue, "text");
    }

    @Test
    public void testReadFullValue() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        byte[] data = new byte[is.available()];
        DataInputStream dataInputStream = new DataInputStream(is);
        dataInputStream.readFully(data);
        dataInputStream.close();
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        valueFields.setByteArrayValue(data);
        String mimeType = "text/plain";
        String encoding = "UTF-16";
        valueFields.setTextValue2(mimeType + SEPARATOR + encoding);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true);
        Assert.assertThat((Object)fileValue.getFilename(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)fileValue.getMimeType(), (Matcher)CoreMatchers.is((Object)mimeType));
        Assert.assertThat((Object)fileValue.getEncoding(), (Matcher)CoreMatchers.is((Object)"UTF-16"));
        Assert.assertThat((Object)fileValue.getEncodingAsCharset(), (Matcher)CoreMatchers.is((Object)Charset.forName("UTF-16")));
        this.checkStreamFromValue((TypedValue)fileValue, "text");
    }

    @Test
    public void testReadFilenameAndByteArrayValue() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/camunda/bpm/engine/test/variables/simpleFile.txt");
        byte[] data = new byte[is.available()];
        DataInputStream dataInputStream = new DataInputStream(is);
        dataInputStream.readFully(data);
        dataInputStream.close();
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        valueFields.setByteArrayValue(data);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true);
        Assert.assertThat((Object)fileValue.getFilename(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)fileValue.getMimeType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.checkStreamFromValue((TypedValue)fileValue, "text");
    }

    @Test
    public void testReadFilenameValue() throws IOException {
        MockValueFields valueFields = new MockValueFields();
        String filename = "file.txt";
        valueFields.setTextValue(filename);
        FileValue fileValue = this.serializer.readValue((ValueFields)valueFields, true);
        Assert.assertThat((Object)fileValue.getFilename(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)fileValue.getMimeType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)fileValue.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testNameIsFile() {
        Assert.assertThat((Object)this.serializer.getName(), (Matcher)CoreMatchers.is((Object)"file"));
    }

    @Test
    public void testWriteFilenameAndEncodingValue() {
        String filename = "test.txt";
        String encoding = "UTF-8";
        FileValue fileValue = (FileValue)Variables.fileValue((String)filename).encoding(encoding).create();
        MockValueFields valueFields = new MockValueFields();
        this.serializer.writeValue(fileValue, (ValueFields)valueFields);
        Assert.assertThat((Object)valueFields.getByteArrayValue().getBytes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)valueFields.getTextValue(), (Matcher)CoreMatchers.is((Object)filename));
        Assert.assertThat((Object)valueFields.getTextValue2(), (Matcher)CoreMatchers.is((Object)(SEPARATOR + encoding)));
    }

    @Test(expected=NullValueException.class)
    public void testSerializeFileValueWithoutName() {
        Variables.fileValue((String)null).file("abc".getBytes()).create();
    }

    private void checkStreamFromValue(TypedValue value, String expected) {
        InputStream stream = (InputStream)value.getValue();
        Scanner scanner = new Scanner(stream);
        Assert.assertThat((Object)scanner.nextLine(), (Matcher)CoreMatchers.is((Object)expected));
    }

    private static class MockValueFields
    implements ValueFields {
        private String name;
        private String textValue;
        private String textValue2;
        private Long longValue;
        private Double doubleValue;
        private ByteArrayEntity byteArrayValue;

        private MockValueFields() {
        }

        public String getName() {
            return this.name;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public void setTextValue(String textValue) {
            this.textValue = textValue;
        }

        public String getTextValue2() {
            return this.textValue2;
        }

        public void setTextValue2(String textValue2) {
            this.textValue2 = textValue2;
        }

        public Long getLongValue() {
            return this.longValue;
        }

        public void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        public Double getDoubleValue() {
            return this.doubleValue;
        }

        public void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public String getByteArrayValueId() {
            return this.byteArrayValue.getId();
        }

        public ByteArrayEntity getByteArrayValue() {
            return this.byteArrayValue;
        }

        public void setByteArrayValue(byte[] bytes) {
            this.byteArrayValue = new ByteArrayEntity(bytes);
        }
    }
}

