/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.QueryValidators;
import org.camunda.bpm.engine.impl.Validator;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.query.QueryProperty;
import org.joda.time.DateTime;

public abstract class AbstractQuery<T extends Query<?, ?>, U>
extends ListQueryParameterObject
implements Command<Object>,
Query<T, U>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SORTORDER_ASC = "asc";
    public static final String SORTORDER_DESC = "desc";
    protected transient CommandExecutor commandExecutor;
    protected ResultType resultType;
    protected List<QueryOrderingProperty> orderingProperties = new ArrayList<QueryOrderingProperty>();
    protected Map<String, String> expressions = new HashMap<String, String>();
    protected Set<Validator<AbstractQuery<?, ?>>> validators = new HashSet();

    protected AbstractQuery() {
    }

    protected AbstractQuery(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        this.addValidator(QueryValidators.AdhocQueryValidator.<AbstractQuery<?, ?>>get());
    }

    public AbstractQuery<T, U> setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public T orderBy(QueryProperty property) {
        return this.orderBy(new QueryOrderingProperty(null, property));
    }

    public T orderBy(QueryOrderingProperty orderProperty) {
        this.orderingProperties.add(orderProperty);
        return (T)this;
    }

    @Override
    public T asc() {
        return this.direction(Direction.ASCENDING);
    }

    @Override
    public T desc() {
        return this.direction(Direction.DESCENDING);
    }

    public T direction(Direction direction) {
        QueryOrderingProperty currentOrderingProperty = null;
        if (!this.orderingProperties.isEmpty()) {
            currentOrderingProperty = this.orderingProperties.get(this.orderingProperties.size() - 1);
        }
        EnsureUtil.ensureNotNull(NotValidException.class, "You should call any of the orderBy methods first before specifying a direction", "currentOrderingProperty", currentOrderingProperty);
        if (currentOrderingProperty.getDirection() != null) {
            EnsureUtil.ensureNull(NotValidException.class, "Invalid query: can specify only one direction desc() or asc() for an ordering constraint", "direction", direction);
        }
        currentOrderingProperty.setDirection(direction);
        return (T)this;
    }

    protected void checkQueryOk() {
        for (QueryOrderingProperty orderingProperty : this.orderingProperties) {
            EnsureUtil.ensureNotNull(NotValidException.class, "Invalid query: call asc() or desc() after using orderByXX()", "direction", (Object)orderingProperty.getDirection());
        }
    }

    @Override
    public U singleResult() {
        this.resultType = ResultType.SINGLE_RESULT;
        if (this.commandExecutor != null) {
            return (U)this.commandExecutor.execute(this);
        }
        return this.executeSingleResult(Context.getCommandContext());
    }

    @Override
    public List<U> list() {
        this.resultType = ResultType.LIST;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.evaluateExpressionsAndExecuteList(Context.getCommandContext(), null);
    }

    @Override
    public List<U> listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.resultType = ResultType.LIST_PAGE;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.evaluateExpressionsAndExecuteList(Context.getCommandContext(), new Page(firstResult, maxResults));
    }

    @Override
    public long count() {
        this.resultType = ResultType.COUNT;
        if (this.commandExecutor != null) {
            return (Long)this.commandExecutor.execute(this);
        }
        return this.evaluateExpressionsAndExecuteCount(Context.getCommandContext());
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.resultType == ResultType.LIST) {
            return this.evaluateExpressionsAndExecuteList(commandContext, null);
        }
        if (this.resultType == ResultType.SINGLE_RESULT) {
            return this.executeSingleResult(commandContext);
        }
        if (this.resultType == ResultType.LIST_PAGE) {
            return this.evaluateExpressionsAndExecuteList(commandContext, null);
        }
        return this.evaluateExpressionsAndExecuteCount(commandContext);
    }

    public long evaluateExpressionsAndExecuteCount(CommandContext commandContext) {
        this.validate();
        this.evaluateExpressions();
        return this.executeCount(commandContext);
    }

    public abstract long executeCount(CommandContext var1);

    public List<U> evaluateExpressionsAndExecuteList(CommandContext commandContext, Page page) {
        this.validate();
        this.evaluateExpressions();
        return this.executeList(commandContext, page);
    }

    public abstract List<U> executeList(CommandContext var1, Page var2);

    public U executeSingleResult(CommandContext commandContext) {
        List<U> results = this.evaluateExpressionsAndExecuteList(commandContext, null);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw new ProcessEngineException("Query return " + results.size() + " results instead of max 1");
        }
        return null;
    }

    @Override
    @Deprecated
    public String getOrderBy() {
        if (this.orderBy == null) {
            return super.getOrderBy();
        }
        return this.orderBy;
    }

    public List<QueryOrderingProperty> getOrderingProperties() {
        return this.orderingProperties;
    }

    public void setOrderingProperties(List<QueryOrderingProperty> orderingProperties) {
        this.orderingProperties = orderingProperties;
    }

    public Map<String, String> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(Map<String, String> expressions) {
        this.expressions = expressions;
    }

    public void addExpression(String key, String expression) {
        this.expressions.put(key, expression);
    }

    protected void evaluateExpressions() {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.expressions.entrySet());
        for (Map.Entry<String, String> entry : entries) {
            Object value;
            String methodName = entry.getKey();
            String expression = entry.getValue();
            try {
                value = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(expression).getValue(null);
            }
            catch (ProcessEngineException e) {
                throw new ProcessEngineException("Unable to resolve expression '" + expression + "' for method '" + methodName + "' on class '" + this.getClass().getCanonicalName() + "'", e);
            }
            if (value instanceof DateTime) {
                value = ((DateTime)value).toDate();
            }
            try {
                Method method = this.getMethod(methodName);
                method.invoke((Object)this, value);
            }
            catch (InvocationTargetException e) {
                throw new ProcessEngineException("Unable to invoke method '" + methodName + "' on class '" + this.getClass().getCanonicalName() + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new ProcessEngineException("Unable to access method '" + methodName + "' on class '" + this.getClass().getCanonicalName() + "'", e);
            }
        }
    }

    protected Method getMethod(String methodName) {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new ProcessEngineException("Unable to find method '" + methodName + "' on class '" + this.getClass().getCanonicalName() + "'");
    }

    public T extend(T extendingQuery) {
        throw new ProcessEngineException("Extending of query type '" + extendingQuery.getClass().getCanonicalName() + "' currently not supported");
    }

    protected void mergeOrdering(AbstractQuery<?, ?> extendedQuery, AbstractQuery<?, ?> extendingQuery) {
        extendedQuery.orderingProperties = this.orderingProperties;
        if (extendingQuery.orderingProperties != null) {
            if (extendedQuery.orderingProperties == null) {
                extendedQuery.orderingProperties = extendingQuery.orderingProperties;
            } else {
                extendedQuery.orderingProperties.addAll(extendingQuery.orderingProperties);
            }
        }
    }

    protected void mergeExpressions(AbstractQuery<?, ?> extendedQuery, AbstractQuery<?, ?> extendingQuery) {
        HashMap<String, String> mergedExpressions = new HashMap<String, String>(extendingQuery.getExpressions());
        for (Map.Entry<String, String> entry : this.getExpressions().entrySet()) {
            if (mergedExpressions.containsKey(entry.getKey())) continue;
            mergedExpressions.put(entry.getKey(), entry.getValue());
        }
        extendedQuery.setExpressions(mergedExpressions);
    }

    public void validate() {
        for (Validator<AbstractQuery<?, ?>> validator : this.validators) {
            this.validate(validator);
        }
    }

    public void validate(Validator<AbstractQuery<?, ?>> validator) {
        validator.validate(this);
    }

    public void addValidator(Validator<AbstractQuery<?, ?>> validator) {
        this.validators.add(validator);
    }

    public void removeValidator(Validator<AbstractQuery<?, ?>> validator) {
        this.validators.remove(validator);
    }

    private static enum ResultType {
        LIST,
        LIST_PAGE,
        SINGLE_RESULT,
        COUNT;

    }
}

