/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ActivityExecutionMapping {
    protected Map<ScopeImpl, Set<ExecutionEntity>> activityExecutionMapping;
    protected CommandContext commandContext;
    protected String processInstanceId;
    protected ActivityExecutionMapping priorMapping;

    public ActivityExecutionMapping(CommandContext commandContext, String processInstanceId) {
        this.commandContext = commandContext;
        this.processInstanceId = processInstanceId;
        this.activityExecutionMapping = new HashMap<ScopeImpl, Set<ExecutionEntity>>();
        this.initialize();
    }

    protected void submitExecution(ExecutionEntity execution, ScopeImpl scope) {
        this.getExecutions(scope).add(execution);
    }

    public Set<ExecutionEntity> getExecutions(ScopeImpl activity) {
        Set<ExecutionEntity> executionsForActivity = this.activityExecutionMapping.get(activity);
        if (executionsForActivity == null) {
            executionsForActivity = new HashSet<ExecutionEntity>();
            this.activityExecutionMapping.put(activity, executionsForActivity);
        }
        return executionsForActivity;
    }

    protected void initialize() {
        ExecutionEntity processInstance = this.commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        List<ExecutionEntity> executions = this.fetchExecutionsForProcessInstance(processInstance);
        executions.add(processInstance);
        List<ExecutionEntity> leaves = this.findLeaves(executions);
        this.assignExecutionsToActivities(leaves);
    }

    protected void assignExecutionsToActivities(List<ExecutionEntity> leaves) {
        for (ExecutionEntity leaf : leaves) {
            ActivityImpl activity = leaf.getActivity();
            if (activity != null) {
                if (leaf.getActivityInstanceId() != null) {
                    EnsureUtil.ensureNotNull("activity", (Object)activity);
                    this.submitExecution(leaf, activity);
                }
                this.mergeScopeExecutions(leaf);
                continue;
            }
            if (!leaf.isProcessInstanceExecution()) continue;
            this.submitExecution(leaf, leaf.getProcessDefinition());
        }
    }

    protected void mergeScopeExecutions(ExecutionEntity leaf) {
        Map<ScopeImpl, PvmExecutionImpl> mapping = leaf.createActivityExecutionMapping();
        for (Map.Entry<ScopeImpl, PvmExecutionImpl> mappingEntry : mapping.entrySet()) {
            ScopeImpl scope = mappingEntry.getKey();
            ExecutionEntity scopeExecution = (ExecutionEntity)mappingEntry.getValue();
            this.submitExecution(scopeExecution, scope);
        }
    }

    protected List<ExecutionEntity> fetchExecutionsForProcessInstance(ExecutionEntity execution) {
        ArrayList<ExecutionEntity> executions = new ArrayList<ExecutionEntity>();
        executions.addAll(execution.getExecutions());
        for (ExecutionEntity child : execution.getExecutions()) {
            executions.addAll(this.fetchExecutionsForProcessInstance(child));
        }
        return executions;
    }

    protected List<ExecutionEntity> findLeaves(List<ExecutionEntity> executions) {
        ArrayList<ExecutionEntity> leaves = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : executions) {
            if (!this.isLeaf(execution)) continue;
            leaves.add(execution);
        }
        return leaves;
    }

    protected boolean isLeaf(ExecutionEntity execution) {
        if (CompensationBehavior.isCompensationThrowing(execution)) {
            return true;
        }
        return !execution.isEventScope() && execution.getNonEventScopeExecutions().isEmpty();
    }
}

