/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.Condition;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;

public class InclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    protected static BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        execution.inactivate();
        this.lockConcurrentRoot(execution);
        PvmActivity activity = execution.getActivity();
        if (!this.activeConcurrentExecutionsExist(execution)) {
            LOG.activityActivation(activity.getId());
            List<ActivityExecution> joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
            String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
            ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
            for (PvmTransition outgoingTransition : execution.getActivity().getOutgoingTransitions()) {
                Condition condition;
                if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && !condition.evaluate(execution)) continue;
                transitionsToTake.add(outgoingTransition);
            }
            if (transitionsToTake.isEmpty()) {
                if (defaultSequenceFlow != null) {
                    PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
                    if (defaultTransition == null) {
                        throw LOG.missingDefaultFlowException(execution.getActivity().getId(), defaultSequenceFlow);
                    }
                    transitionsToTake.add(defaultTransition);
                } else {
                    throw LOG.stuckExecutionException(execution.getActivity().getId());
                }
            }
            execution.leaveActivityViaTransitions(transitionsToTake, joinedExecutions);
        } else {
            LOG.noActivityActivation(activity.getId());
        }
    }

    protected List<? extends ActivityExecution> getLeaveExecutions(ActivityExecution parent) {
        ArrayList<? extends ActivityExecution> executionlist = new ArrayList<ActivityExecution>();
        List<? extends ActivityExecution> subExecutions = parent.getExecutions();
        if (subExecutions.size() == 0) {
            executionlist.add(parent);
        } else {
            for (ActivityExecution activityExecution : subExecutions) {
                executionlist.addAll(this.getLeaveExecutions(activityExecution));
            }
        }
        return executionlist;
    }

    public boolean activeConcurrentExecutionsExist(ActivityExecution execution) {
        PvmActivity activity = execution.getActivity();
        if (execution.isConcurrent()) {
            for (ActivityExecution activityExecution : this.getLeaveExecutions(execution.getParent())) {
                if (!activityExecution.isActive()) continue;
                boolean reachable = false;
                TransitionImpl pvmTransition = activityExecution.getTransition();
                reachable = pvmTransition != null ? this.isReachable(pvmTransition.getDestination(), activity, new HashSet<PvmActivity>()) : this.isReachable(activityExecution.getActivity(), activity, new HashSet<PvmActivity>());
                if (!reachable) continue;
                LOG.activeConcurrentExecutionFound(activityExecution.getActivity());
                return true;
            }
        } else if (execution.isActive()) {
            LOG.activeConcurrentExecutionFound(execution.getActivity());
            return true;
        }
        return false;
    }

    protected boolean isReachable(PvmActivity srcActivity, PvmActivity targetActivity, Set<PvmActivity> visitedActivities) {
        if (srcActivity.getOutgoingTransitions().size() == 0) {
            visitedActivities.add(srcActivity);
            if (srcActivity.getFlowScope() == null || !(srcActivity.getFlowScope() instanceof PvmActivity)) {
                return false;
            }
            srcActivity = (PvmActivity)((Object)srcActivity.getFlowScope());
        }
        if (srcActivity.equals(targetActivity)) {
            return true;
        }
        visitedActivities.add(srcActivity);
        List<PvmTransition> transitionList = srcActivity.getOutgoingTransitions();
        if (transitionList != null && transitionList.size() > 0) {
            for (PvmTransition pvmTransition : transitionList) {
                boolean reachable;
                PvmActivity destinationActivity = pvmTransition.getDestination();
                if (destinationActivity == null || visitedActivities.contains(destinationActivity) || !(reachable = this.isReachable(destinationActivity, targetActivity, visitedActivities))) continue;
                return true;
            }
        }
        return false;
    }
}

