/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.util.io.StreamSource;

public class BpmnParseLogger
extends ProcessEngineLogger {
    public void parsingElement(String elementType, String elementId) {
        this.logDebug("001", "Parsing element from type '{}' with id '{}'", new Object[]{elementType, elementId});
    }

    public void ignoringNonExecutableProcess(String elementId) {
        this.logInfo("002", "Ignoring non-executable process with id '{}'. Set the attribute isExecutable=\"true\" to deploy this process.", new Object[]{elementId});
    }

    public void missingIsExecutableAttribute(String elementId) {
        this.logInfo("003", "Process with id '{}' has no attribute isExecutable. Better set the attribute explicitly, especially to be compatible with future engine versions which might change the default behavior.", new Object[]{elementId});
    }

    public void parsingFailure(Throwable cause) {
        this.logError("004", "Unexpected Exception with message: {} ", new Object[]{cause.getMessage()});
    }

    public void unableToSetSchemaResource(Throwable cause) {
        this.logWarn("005", "Setting schema resource failed because of: '{}'", new Object[]{cause.getMessage()});
    }

    public ProcessEngineException malformedUrlException(String url, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("006", "The URL '{}' is malformed", new Object[]{url}), cause);
    }

    public ProcessEngineException multipleSourcesException(StreamSource source1, StreamSource source2) {
        return new ProcessEngineException(this.exceptionMessage("007", "Multiple sources detected, which is invalid. Source 1: '{}', Source 2: {}", new Object[]{source1, source2}));
    }

    public ProcessEngineException parsingFailureException(String name, Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("008", "Could not parse '{}'.", new Object[]{name}), cause);
    }

    public ProcessEngineException parsingProcessException(Exception cause) {
        return new ProcessEngineException(this.exceptionMessage("009", "Error while parsing process", new Object[0]), cause);
    }
}

