/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmd.ActivateProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentFailListener;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessApplicationDeploymentImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.repository.ProcessApplicationDeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.instance.Case;

public class DeployCmd<T>
implements Command<Deployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DeployCmd.class.getName());
    protected DeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deployment execute(CommandContext commandContext) {
        Class<ProcessEngine> clazz = ProcessEngine.class;
        synchronized (ProcessEngine.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.doExecute(commandContext);
        }
    }

    protected Deployment doExecute(final CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCreateDeployment();
        return commandContext.runWithoutAuthorization(new Callable<Deployment>(){

            @Override
            public Deployment call() throws Exception {
                DeployCmd.this.acquireExclusiveLock(commandContext);
                DeploymentEntity deployment = DeployCmd.this.initDeployment();
                Map<String, ResourceEntity> resourcesToDeploy = DeployCmd.this.resolveResourcesToDeploy(commandContext, deployment);
                HashMap<String, ResourceEntity> resourcesToIgnore = new HashMap<String, ResourceEntity>(deployment.getResources());
                resourcesToIgnore.keySet().removeAll(resourcesToDeploy.keySet());
                if (!resourcesToDeploy.isEmpty()) {
                    log.fine("Creating new deployment.");
                    deployment.setResources(resourcesToDeploy);
                    DeployCmd.this.deploy(deployment);
                } else {
                    log.fine("Using existing deployment.");
                    deployment = DeployCmd.this.getExistingDeployment(commandContext, deployment.getName());
                }
                DeployCmd.this.scheduleProcessDefinitionActivation(commandContext, deployment);
                if (DeployCmd.this.deploymentBuilder instanceof ProcessApplicationDeploymentBuilder) {
                    Set<String> processesToRegisterFor = DeployCmd.this.retrieveProcessKeysFromResources(resourcesToIgnore);
                    ProcessApplicationRegistration registration = DeployCmd.this.registerProcessApplication(commandContext, deployment, processesToRegisterFor);
                    return new ProcessApplicationDeploymentImpl(deployment, registration);
                }
                DeployCmd.this.registerWithJobExecutor(commandContext, deployment);
                return deployment;
            }
        });
    }

    protected void acquireExclusiveLock(CommandContext commandContext) {
        if (Context.getProcessEngineConfiguration().isDeploymentLockUsed()) {
            commandContext.getPropertyManager().acquireExclusiveLock();
        }
    }

    protected DeploymentEntity initDeployment() {
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(ClockUtil.getCurrentTime());
        return deployment;
    }

    protected Map<String, ResourceEntity> resolveResourcesToDeploy(CommandContext commandContext, DeploymentEntity deployment) {
        Map<Object, Object> resourcesToDeploy = new HashMap();
        Map<String, ResourceEntity> containedResources = deployment.getResources();
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            Map<String, ResourceEntity> existingResources = commandContext.getResourceManager().findLatestResourcesByDeploymentName(deployment.getName(), containedResources.keySet());
            for (ResourceEntity deployedResource : containedResources.values()) {
                String resourceName = deployedResource.getName();
                ResourceEntity existingResource = existingResources.get(resourceName);
                if (existingResource != null && !existingResource.isGenerated() && !this.resourcesDiffer(deployedResource, existingResource)) continue;
                if (this.deploymentBuilder.isDeployChangedOnly()) {
                    resourcesToDeploy.put(resourceName, deployedResource);
                    continue;
                }
                resourcesToDeploy = containedResources;
                break;
            }
        } else {
            resourcesToDeploy = containedResources;
        }
        return resourcesToDeploy;
    }

    protected boolean resourcesDiffer(ResourceEntity resource, ResourceEntity existing) {
        byte[] savedBytes;
        byte[] bytes = resource.getBytes();
        return !Arrays.equals(bytes, savedBytes = existing.getBytes());
    }

    protected void deploy(DeploymentEntity deployment) {
        deployment.setNew(true);
        Context.getCommandContext().getDeploymentManager().insertDeployment(deployment);
    }

    protected DeploymentEntity getExistingDeployment(CommandContext commandContext, String deploymentName) {
        return commandContext.getDeploymentManager().findLatestDeploymentByName(deploymentName);
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentEntity deployment) {
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            for (ProcessDefinitionEntity processDefinitionEntity : deployment.getDeployedArtifacts(ProcessDefinitionEntity.class)) {
                SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionEntity, false, null);
                suspendProcessDefinitionCmd.execute(commandContext);
                ActivateProcessDefinitionCmd activateProcessDefinitionCmd = new ActivateProcessDefinitionCmd(processDefinitionEntity, false, this.deploymentBuilder.getProcessDefinitionsActivationDate());
                activateProcessDefinitionCmd.execute(commandContext);
            }
        }
    }

    protected ProcessApplicationRegistration registerProcessApplication(CommandContext commandContext, DeploymentEntity deployment, Set<String> processKeysToRegisterFor) {
        ProcessApplicationDeploymentBuilderImpl appDeploymentBuilder = (ProcessApplicationDeploymentBuilderImpl)this.deploymentBuilder;
        ProcessApplicationReference appReference = appDeploymentBuilder.getProcessApplicationReference();
        HashSet<String> deploymentsToRegister = new HashSet<String>(Collections.singleton(deployment.getId()));
        if (appDeploymentBuilder.isResumePreviousVersions()) {
            if ("process-definition-key".equals(appDeploymentBuilder.getResumePreviousVersionsBy())) {
                deploymentsToRegister.addAll(this.resumePreviousByProcessDefinitionKey(commandContext, deployment, processKeysToRegisterFor));
            } else if ("deployment-name".equals(appDeploymentBuilder.getResumePreviousVersionsBy())) {
                deploymentsToRegister.addAll(this.resumePreviousByDeploymentName(commandContext, deployment));
            }
        }
        return new RegisterProcessApplicationCmd(deploymentsToRegister, appReference).execute(commandContext);
    }

    protected Set<String> resumePreviousByProcessDefinitionKey(CommandContext commandContext, DeploymentEntity deployment, Set<String> processKeysToRegisterFor) {
        HashSet<String> processDefinitionKeys = new HashSet<String>(processKeysToRegisterFor);
        List<ProcessDefinition> deployedProcesses = this.getDeployedProcesses(deployment);
        for (ProcessDefinition deployedProcess : deployedProcesses) {
            if (deployedProcess.getVersion() <= 1) continue;
            processDefinitionKeys.add(deployedProcess.getKey());
        }
        return this.findDeploymentIdsForProcessDefinitions(commandContext, processDefinitionKeys);
    }

    protected Set<String> resumePreviousByDeploymentName(CommandContext commandContext, DeploymentEntity deployment) {
        List previousDeployments = new DeploymentQueryImpl().deploymentName(deployment.getName()).list();
        HashSet<String> deploymentIds = new HashSet<String>(previousDeployments.size());
        for (Deployment d : previousDeployments) {
            deploymentIds.add(d.getId());
        }
        return deploymentIds;
    }

    protected List<? extends ProcessDefinition> getDeployedProcesses(DeploymentEntity deployment) {
        List<ProcessDefinition> deployedProcessDefinitions = deployment.getDeployedArtifacts(ProcessDefinitionEntity.class);
        if (deployedProcessDefinitions == null) {
            CommandContext commandContext = Context.getCommandContext();
            ProcessDefinitionManager manager = commandContext.getProcessDefinitionManager();
            deployedProcessDefinitions = manager.findProcessDefinitionsByDeploymentId(deployment.getId());
        }
        return deployedProcessDefinitions;
    }

    protected Set<String> retrieveProcessKeysFromResources(Map<String, ResourceEntity> resources) {
        HashSet<String> keys = new HashSet<String>();
        for (ResourceEntity resource : resources.values()) {
            BpmnModelInstance model;
            ByteArrayInputStream byteStream;
            if (this.isBpmnResource(resource)) {
                byteStream = new ByteArrayInputStream(resource.getBytes());
                model = Bpmn.readModelFromStream((InputStream)byteStream);
                for (Process process : model.getDefinitions().getChildElementsByType(Process.class)) {
                    keys.add(process.getId());
                }
                continue;
            }
            if (!this.isCmmnResource(resource)) continue;
            byteStream = new ByteArrayInputStream(resource.getBytes());
            model = Cmmn.readModelFromStream((InputStream)byteStream);
            for (Case cmmnCase : model.getDefinitions().getCases()) {
                keys.add(cmmnCase.getId());
            }
        }
        return keys;
    }

    protected boolean isBpmnResource(ResourceEntity resourceEntity) {
        return StringUtil.hasAnySuffix(resourceEntity.getName(), BpmnDeployer.BPMN_RESOURCE_SUFFIXES);
    }

    protected boolean isCmmnResource(ResourceEntity resourceEntity) {
        return StringUtil.hasAnySuffix(resourceEntity.getName(), CmmnDeployer.CMMN_RESOURCE_SUFFIXES);
    }

    protected Set<String> findDeploymentIdsForProcessDefinitions(CommandContext commandContext, Set<String> processDefinitionKeys) {
        HashSet<String> deploymentsToRegister = new HashSet<String>();
        if (!processDefinitionKeys.isEmpty()) {
            String[] keys = processDefinitionKeys.toArray(new String[processDefinitionKeys.size()]);
            ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
            List<ProcessDefinition> previousDefinitions = processDefinitionManager.findProcessDefinitionsByKeyIn(keys);
            for (ProcessDefinition definition : previousDefinitions) {
                deploymentsToRegister.add(definition.getDeploymentId());
            }
        }
        return deploymentsToRegister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWithJobExecutor(CommandContext commandContext, DeploymentEntity deployment) {
        try {
            new RegisterDeploymentCmd(deployment.getId()).execute(commandContext);
        }
        finally {
            DeploymentFailListener listener = new DeploymentFailListener(deployment.getId());
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Could not register transaction synchronization. Probably the TX has already been rolled back by application code.", e);
                listener.execute(commandContext);
            }
        }
    }
}

