/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;

public class ModifyProcessInstanceCmd
implements Command<Void> {
    private static final Logger LOG = Logger.getLogger(ModifyProcessInstanceCmd.class.getName());
    protected static final String INSTRUCTION_LOG_FORMAT = "Modifying process instance '%s': Instruction %s: %s";
    protected ProcessInstanceModificationBuilderImpl builder;

    public ModifyProcessInstanceCmd(ProcessInstanceModificationBuilderImpl processInstanceModificationBuilder) {
        this.builder = processInstanceModificationBuilder;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String processInstanceId = this.builder.getProcessInstanceId();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(processInstanceId);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstance(processInstance);
        processInstance.setPreserveScope(true);
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getModificationOperations();
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractProcessInstanceModificationCommand instruction = instructions.get(i);
            this.logInstruction(processInstanceId, i, instruction);
            instruction.setSkipCustomListeners(this.builder.isSkipCustomListeners());
            instruction.setSkipIoMappings(this.builder.isSkipIoMappings());
            instruction.execute(commandContext);
        }
        processInstance = executionManager.findExecutionById(processInstanceId);
        if (!processInstance.hasChildren()) {
            if (processInstance.getActivity() == null) {
                authorizationManager.checkDeleteProcessInstance(processInstance);
                processInstance.deleteCascade("Cancellation due to process instance modification", this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
            } else if (processInstance.isEnded()) {
                processInstance.propagateEnd();
            }
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), processInstanceId, null, null, PropertyChange.EMPTY_CHANGE);
        return null;
    }

    protected void logInstruction(String processInstanceId, int index, AbstractProcessInstanceModificationCommand instruction) {
        LOG.info(String.format(INSTRUCTION_LOG_FORMAT, processInstanceId, index + 1, instruction.describe()));
    }

    protected String getLogEntryOperation() {
        return "ModifyProcessInstance";
    }
}

