/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetProcessDefinitionVersionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String processInstanceId;
    private final Integer processDefinitionVersion;

    public SetProcessDefinitionVersionCmd(String processInstanceId, Integer processDefinitionVersion) {
        EnsureUtil.ensureNotEmpty("The process instance id is mandatory", "processInstanceId", processInstanceId);
        EnsureUtil.ensureNotNull("The process definition version is mandatory", "processDefinitionVersion", (Object)processDefinitionVersion);
        EnsureUtil.ensurePositive("The process definition version must be positive", "processDefinitionVersion", processDefinitionVersion);
        this.processInstanceId = processInstanceId;
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(this.processInstanceId);
        if (processInstance == null) {
            throw new ProcessEngineException("No process instance found for id = '" + this.processInstanceId + "'.");
        }
        if (!processInstance.isProcessInstanceExecution()) {
            throw new ProcessEngineException("A process instance id is required, but the provided id '" + this.processInstanceId + "' " + "points to a child execution of process instance " + "'" + processInstance.getProcessInstanceId() + "'. " + "Please invoke the " + this.getClass().getSimpleName() + " with a root execution id.");
        }
        ProcessDefinitionImpl currentProcessDefinitionImpl = processInstance.getProcessDefinition();
        DeploymentCache deploymentCache = configuration.getDeploymentCache();
        ProcessDefinitionEntity currentProcessDefinition = currentProcessDefinitionImpl instanceof ProcessDefinitionEntity ? (ProcessDefinitionEntity)currentProcessDefinitionImpl : deploymentCache.findDeployedProcessDefinitionById(currentProcessDefinitionImpl.getId());
        ProcessDefinitionEntity newProcessDefinition = deploymentCache.findDeployedProcessDefinitionByKeyAndVersion(currentProcessDefinition.getKey(), this.processDefinitionVersion);
        this.validateAndSwitchVersionOfExecution(commandContext, processInstance, newProcessDefinition);
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_UPDATE, processInstance)) {
            HistoryEventProducer eventFactory = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent event = eventFactory.createProcessInstanceUpdateEvt(processInstance);
            eventHandler.handleEvent(event);
        }
        List<ExecutionEntity> childExecutions = executionManager.findChildExecutionsByProcessInstanceId(this.processInstanceId);
        for (ExecutionEntity executionEntity : childExecutions) {
            this.validateAndSwitchVersionOfExecution(commandContext, executionEntity, newProcessDefinition);
        }
        List<JobEntity> jobs = commandContext.getJobManager().findJobsByProcessInstanceId(this.processInstanceId);
        List<JobDefinitionEntity> currentJobDefinitions = commandContext.getJobDefinitionManager().findByProcessDefinitionId(currentProcessDefinition.getId());
        List<JobDefinitionEntity> newVersionJobDefinitions = commandContext.getJobDefinitionManager().findByProcessDefinitionId(newProcessDefinition.getId());
        Map<String, String> jobDefinitionMapping = this.getJobDefinitionMapping(currentJobDefinitions, newVersionJobDefinitions);
        for (JobEntity jobEntity : jobs) {
            this.switchVersionOfJob(jobEntity, newProcessDefinition, jobDefinitionMapping);
        }
        List<IncidentEntity> incidents = commandContext.getIncidentManager().findIncidentsByProcessInstance(this.processInstanceId);
        for (IncidentEntity incidentEntity : incidents) {
            this.switchVersionOfIncident(commandContext, incidentEntity, newProcessDefinition);
        }
        PropertyChange change = new PropertyChange("processDefinitionVersion", currentProcessDefinition.getVersion(), this.processDefinitionVersion);
        commandContext.getOperationLogManager().logProcessInstanceOperation("ModifyProcessInstance", this.processInstanceId, null, null, change);
        return null;
    }

    protected Map<String, String> getJobDefinitionMapping(List<JobDefinitionEntity> currentJobDefinitions, List<JobDefinitionEntity> newVersionJobDefinitions) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        block0: for (JobDefinitionEntity currentJobDefinition : currentJobDefinitions) {
            for (JobDefinitionEntity newJobDefinition : newVersionJobDefinitions) {
                if (!this.jobDefinitionsMatch(currentJobDefinition, newJobDefinition)) continue;
                mapping.put(currentJobDefinition.getId(), newJobDefinition.getId());
                continue block0;
            }
        }
        return mapping;
    }

    protected boolean jobDefinitionsMatch(JobDefinitionEntity currentJobDefinition, JobDefinitionEntity newJobDefinition) {
        boolean activitiesMatch = currentJobDefinition.getActivityId().equals(newJobDefinition.getActivityId());
        boolean typesMatch = currentJobDefinition.getJobType() == null && newJobDefinition.getJobType() == null || currentJobDefinition.getJobType() != null && currentJobDefinition.getJobType().equals(newJobDefinition.getJobType());
        boolean configurationsMatch = currentJobDefinition.getJobConfiguration() == null && newJobDefinition.getJobConfiguration() == null || currentJobDefinition.getJobConfiguration() != null && currentJobDefinition.getJobConfiguration().equals(newJobDefinition.getJobConfiguration());
        return activitiesMatch && typesMatch && configurationsMatch;
    }

    protected void switchVersionOfJob(JobEntity jobEntity, ProcessDefinitionEntity newProcessDefinition, Map<String, String> jobDefinitionMapping) {
        jobEntity.setProcessDefinitionId(newProcessDefinition.getId());
        jobEntity.setDeploymentId(newProcessDefinition.getDeploymentId());
        String newJobDefinitionId = jobDefinitionMapping.get(jobEntity.getJobDefinitionId());
        jobEntity.setJobDefinitionId(newJobDefinitionId);
    }

    protected void switchVersionOfIncident(CommandContext commandContext, IncidentEntity incidentEntity, ProcessDefinitionEntity newProcessDefinition) {
        incidentEntity.setProcessDefinitionId(newProcessDefinition.getId());
    }

    protected void validateAndSwitchVersionOfExecution(CommandContext commandContext, ExecutionEntity execution, ProcessDefinitionEntity newProcessDefinition) {
        if (execution.getActivity() != null) {
            String activityId = execution.getActivity().getId();
            ActivityImpl newActivity = newProcessDefinition.findActivity(activityId);
            if (newActivity == null) {
                throw new ProcessEngineException("The new process definition (key = '" + newProcessDefinition.getKey() + "') " + "does not contain the current activity " + "(id = '" + activityId + "') " + "of the process instance " + "(id = '" + this.processInstanceId + "').");
            }
            execution.setActivity(newActivity);
        }
        execution.setProcessDefinition(newProcessDefinition);
        List<TaskEntity> tasks = commandContext.getTaskManager().findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : tasks) {
            taskEntity.setProcessDefinitionId(newProcessDefinition.getId());
        }
    }
}

