/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SignalEventReceivedCmd
implements Command<Void> {
    private static final Logger LOGGER = Logger.getLogger(SignalEventReceivedCmd.class.getName());
    protected final String eventName;
    protected final String executionId;
    protected final Map<String, Object> variables;

    public SignalEventReceivedCmd(String eventName, String executionId, Map<String, Object> variables) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.variables = variables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.executionId == null) {
            List<SignalEventSubscriptionEntity> signalEventSubscriptions = eventSubscriptionManager.findSignalEventSubscriptionsByEventName(this.eventName);
            List<SignalEventSubscriptionEntity> catchSignalEventSubscription = this.filterIntermediateSubscriptions(signalEventSubscriptions);
            List<SignalEventSubscriptionEntity> startSignalEventSubscriptions = this.filterStartSubscriptions(signalEventSubscriptions);
            Map<String, ProcessDefinitionEntity> processDefinitions = this.getProcessDefinitionsOfSubscriptions(startSignalEventSubscriptions);
            this.checkAuthorizationOfCatchSignals(authorizationManager, catchSignalEventSubscription);
            this.checkAuthorizationOfStartSignals(authorizationManager, startSignalEventSubscriptions, processDefinitions);
            this.notifyExecutions(catchSignalEventSubscription);
            this.startProcessInstances(startSignalEventSubscriptions, processDefinitions);
        } else {
            ExecutionManager executionManager = commandContext.getExecutionManager();
            ExecutionEntity execution = executionManager.findExecutionById(this.executionId);
            EnsureUtil.ensureNotNull("Cannot find execution with id '" + this.executionId + "'", "execution", (Object)execution);
            List<SignalEventSubscriptionEntity> signalEvents = eventSubscriptionManager.findSignalEventSubscriptionsByNameAndExecution(this.eventName, this.executionId);
            EnsureUtil.ensureNotEmpty("Execution '" + this.executionId + "' has not subscribed to a signal event with name '" + this.eventName + "'.", signalEvents);
            this.checkAuthorizationOfCatchSignals(authorizationManager, signalEvents);
            this.notifyExecutions(signalEvents);
        }
        return null;
    }

    protected Map<String, ProcessDefinitionEntity> getProcessDefinitionsOfSubscriptions(List<SignalEventSubscriptionEntity> startSignalEventSubscriptions) {
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        HashMap<String, ProcessDefinitionEntity> processDefinitions = new HashMap<String, ProcessDefinitionEntity>();
        for (SignalEventSubscriptionEntity eventSubscription : startSignalEventSubscriptions) {
            String processDefinitionId = eventSubscription.getConfiguration();
            EnsureUtil.ensureNotNull("Configuration of signal start event subscription '" + eventSubscription.getId() + "' contains no process definition id.", (Object)processDefinitionId);
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
            if (processDefinition == null || processDefinition.isSuspended()) {
                LOGGER.log(Level.FINE, "Found event subscription with {0} but process definition {1} could not be found.", new Object[]{eventSubscription, processDefinitionId});
                continue;
            }
            processDefinitions.put(eventSubscription.getId(), processDefinition);
        }
        return processDefinitions;
    }

    protected void checkAuthorizationOfCatchSignals(AuthorizationManager authorizationManager, List<SignalEventSubscriptionEntity> catchSignalEventSubscription) {
        for (SignalEventSubscriptionEntity event : catchSignalEventSubscription) {
            String processInstanceId = event.getProcessInstanceId();
            authorizationManager.checkUpdateProcessInstanceById(processInstanceId);
        }
    }

    private void checkAuthorizationOfStartSignals(AuthorizationManager authorizationManager, List<SignalEventSubscriptionEntity> startSignalEventSubscriptions, Map<String, ProcessDefinitionEntity> processDefinitions) {
        for (SignalEventSubscriptionEntity signalStartEventSubscription : startSignalEventSubscriptions) {
            ProcessDefinitionEntity processDefinition = processDefinitions.get(signalStartEventSubscription.getId());
            if (processDefinition == null) continue;
            authorizationManager.checkCreateProcessInstance(processDefinition);
        }
    }

    private void notifyExecutions(List<SignalEventSubscriptionEntity> catchSignalEventSubscription) {
        HashMap<String, Object> payload = null;
        if (this.variables != null) {
            payload = new HashMap<String, Object>(this.variables);
        }
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : catchSignalEventSubscription) {
            if (!this.isActiveEventSubscription(signalEventSubscriptionEntity)) continue;
            signalEventSubscriptionEntity.eventReceived(payload, false);
        }
    }

    private boolean isActiveEventSubscription(SignalEventSubscriptionEntity signalEventSubscriptionEntity) {
        ExecutionEntity execution = signalEventSubscriptionEntity.getExecution();
        return !execution.isEnded() && !execution.isCanceled();
    }

    private void startProcessInstances(List<SignalEventSubscriptionEntity> startSignalEventSubscriptions, Map<String, ProcessDefinitionEntity> processDefinitions) {
        for (SignalEventSubscriptionEntity signalStartEventSubscription : startSignalEventSubscriptions) {
            ProcessDefinitionEntity processDefinition = processDefinitions.get(signalStartEventSubscription.getId());
            if (processDefinition == null) continue;
            ActivityImpl signalStartEvent = processDefinition.findActivity(signalStartEventSubscription.getActivityId());
            PvmProcessInstance processInstance = processDefinition.createProcessInstanceForInitial(signalStartEvent);
            processInstance.start(this.variables);
        }
    }

    protected List<SignalEventSubscriptionEntity> filterIntermediateSubscriptions(List<SignalEventSubscriptionEntity> subscriptions) {
        ArrayList<SignalEventSubscriptionEntity> result = new ArrayList<SignalEventSubscriptionEntity>();
        for (SignalEventSubscriptionEntity subscription : subscriptions) {
            if (subscription.getExecutionId() == null) continue;
            result.add(subscription);
        }
        return result;
    }

    protected List<SignalEventSubscriptionEntity> filterStartSubscriptions(List<SignalEventSubscriptionEntity> subscriptions) {
        ArrayList<SignalEventSubscriptionEntity> result = new ArrayList<SignalEventSubscriptionEntity>();
        for (SignalEventSubscriptionEntity subscription : subscriptions) {
            if (subscription.getExecutionId() != null) continue;
            result.add(subscription);
        }
        return result;
    }
}

