/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.deployer;

import java.util.List;
import org.camunda.bpm.engine.impl.AbstractDefinitionDeployer;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformer;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class CmmnDeployer
extends AbstractDefinitionDeployer<CaseDefinitionEntity> {
    public static final String[] CMMN_RESOURCE_SUFFIXES = new String[]{"cmmn10.xml", "cmmn"};
    protected ExpressionManager expressionManager;
    protected CmmnTransformer transformer;

    @Override
    protected String[] getResourcesSuffixes() {
        return CMMN_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<CaseDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource) {
        return this.transformer.createTransform().deployment(deployment).resource(resource).transform();
    }

    @Override
    protected CaseDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getCaseDefinitionManager().findCaseDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected CaseDefinitionEntity findLatestDefinitionByKey(String definitionKey) {
        return this.getCaseDefinitionManager().findLatestCaseDefinitionByKey(definitionKey);
    }

    @Override
    protected void persistDefinition(CaseDefinitionEntity definition) {
        this.getCaseDefinitionManager().insertCaseDefinition(definition);
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, CaseDefinitionEntity definition) {
        deploymentCache.addCaseDefinition(definition);
    }

    protected CaseDefinitionManager getCaseDefinitionManager() {
        return this.getCommandContext().getCaseDefinitionManager();
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public CmmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(CmmnTransformer transformer) {
        this.transformer = transformer;
    }
}

