/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import java.util.Collection;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnIfPartDeclaration;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnOnPartDeclaration;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformerLogger;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.model.cmmn.PlanItemTransition;
import org.camunda.bpm.model.cmmn.impl.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.instance.CaseFileItemOnPart;
import org.camunda.bpm.model.cmmn.instance.IfPart;
import org.camunda.bpm.model.cmmn.instance.OnPart;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemOnPart;
import org.camunda.bpm.model.cmmn.instance.Sentry;

public class SentryHandler
extends CmmnElementHandler<Sentry, CmmnSentryDeclaration> {
    protected static final CmmnTransformerLogger LOG = ProcessEngineLogger.CMMN_TRANSFORMER_LOGGER;

    @Override
    public CmmnSentryDeclaration handleElement(Sentry element, CmmnHandlerContext context) {
        String id = element.getId();
        Collection onParts = element.getOnParts();
        IfPart ifPart = element.getIfPart();
        if (ifPart == null || ifPart.getConditions().isEmpty()) {
            if (onParts == null || onParts.isEmpty()) {
                LOG.ignoredSentryWithMissingCondition(id);
                return null;
            }
            boolean atLeastOneOnPartsValid = false;
            for (OnPart onPart : onParts) {
                PlanItemOnPart planItemOnPart;
                if (!(onPart instanceof PlanItemOnPart) || (planItemOnPart = (PlanItemOnPart)onPart).getSource() == null || planItemOnPart.getStandardEvent() == null) continue;
                atLeastOneOnPartsValid = true;
                break;
            }
            if (!atLeastOneOnPartsValid) {
                LOG.ignoredSentryWithInvalidParts(id);
                return null;
            }
        }
        CmmnSentryDeclaration sentryDeclaration = new CmmnSentryDeclaration(id);
        this.initializeIfPart(ifPart, sentryDeclaration, context);
        CmmnActivity parent = context.getParent();
        if (parent != null) {
            parent.addSentry(sentryDeclaration);
        }
        return sentryDeclaration;
    }

    public void initializeOnParts(Sentry sentry, CmmnHandlerContext context) {
        Collection onParts = sentry.getOnParts();
        for (OnPart onPart : onParts) {
            if (onPart instanceof PlanItemOnPart) {
                this.initializeOnPart((PlanItemOnPart)onPart, sentry, context);
                continue;
            }
            this.initializeOnPart((CaseFileItemOnPart)onPart, sentry, context);
        }
    }

    protected void initializeOnPart(PlanItemOnPart onPart, Sentry sentry, CmmnHandlerContext context) {
        CmmnActivity parent = context.getParent();
        String sentryId = sentry.getId();
        CmmnSentryDeclaration sentryDeclaration = parent.getSentry(sentryId);
        PlanItem source = onPart.getSource();
        PlanItemTransition standardEvent = onPart.getStandardEvent();
        if (source != null && standardEvent != null) {
            Sentry sentryRef;
            CmmnOnPartDeclaration onPartDeclaration = new CmmnOnPartDeclaration();
            String standardEventName = standardEvent.name();
            onPartDeclaration.setStandardEvent(standardEventName);
            String sourceId = source.getId();
            CmmnActivity sourceActivity = parent.findActivity(sourceId);
            if (sourceActivity != null) {
                onPartDeclaration.setSource(sourceActivity);
            }
            if ((sentryRef = onPart.getSentry()) != null) {
                String sentryRefId = sentryRef.getId();
                CmmnSentryDeclaration sentryRefDeclaration = parent.getSentry(sentryRefId);
                onPartDeclaration.setSentry(sentryRefDeclaration);
            }
            sentryDeclaration.addOnPart(onPartDeclaration);
        }
    }

    protected void initializeOnPart(CaseFileItemOnPart onPart, Sentry sentry, CmmnHandlerContext context) {
        String id = sentry.getId();
        LOG.ignoredUnsupportedAttribute("onPart", "CaseFileItem", id);
    }

    protected void initializeIfPart(IfPart ifPart, CmmnSentryDeclaration sentryDeclaration, CmmnHandlerContext context) {
        if (ifPart == null) {
            return;
        }
        Collection conditions = ifPart.getConditions();
        if (conditions.size() > 1) {
            String id = sentryDeclaration.getId();
            LOG.multipleIgnoredConditions(id);
        }
        ExpressionManager expressionManager = context.getExpressionManager();
        ConditionExpression condition = (ConditionExpression)conditions.iterator().next();
        Expression conditionExpression = expressionManager.createExpression(condition.getBody());
        CmmnIfPartDeclaration ifPartDeclaration = new CmmnIfPartDeclaration();
        ifPartDeclaration.setCondition(conditionExpression);
        sentryDeclaration.setIfPart(ifPartDeclaration);
    }
}

