/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.operation;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnCompositeActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.TransferVariablesActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.operation.AbstractCmmnEventAtomicOperation;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnOperationLogger;
import org.camunda.bpm.engine.impl.core.delegate.CoreActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.util.ActivityBehaviorUtil;

public abstract class AbstractAtomicOperationCaseExecutionComplete
extends AbstractCmmnEventAtomicOperation {
    protected static final CmmnOperationLogger LOG = ProcessEngineLogger.CMMN_OPERATION_LOGGER;

    @Override
    protected String getEventName() {
        return "complete";
    }

    @Override
    protected CmmnExecution eventNotificationsStarted(CmmnExecution execution) {
        CmmnActivityBehavior behavior = ActivityBehaviorUtil.getActivityBehavior(execution);
        this.triggerBehavior(behavior, execution);
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                cmmnExecution.remove();
            }
        }
        execution.setCurrentState(CaseExecutionState.COMPLETED);
        return execution;
    }

    @Override
    protected void postTransitionNotification(CmmnExecution execution) {
        CmmnActivityBehavior behavior;
        if (!execution.isCaseInstanceExecution()) {
            execution.remove();
        } else {
            CoreActivityBehavior<CmmnActivityExecution> behavior2;
            CmmnExecution superCaseExecution = execution.getSuperCaseExecution();
            PvmExecutionImpl superExecution = execution.getSuperExecution();
            if (superCaseExecution != null) {
                behavior2 = (TransferVariablesActivityBehavior)ActivityBehaviorUtil.getActivityBehavior(superCaseExecution);
                behavior2.transferVariables(execution, superCaseExecution);
                superCaseExecution.complete();
            } else if (superExecution != null) {
                behavior2 = (SubProcessActivityBehavior)ActivityBehaviorUtil.getActivityBehavior(superExecution);
                try {
                    behavior2.passOutputVariablesFromSubprocess(superExecution, execution);
                }
                catch (RuntimeException e) {
                    LOG.completingSubCaseError(execution, e);
                    throw e;
                }
                catch (Exception e) {
                    LOG.completingSubCaseError(execution, e);
                    throw LOG.completingSubCaseErrorException(execution, e);
                }
                superExecution.setSubCaseInstance(null);
                try {
                    behavior2.completed(superExecution);
                }
                catch (RuntimeException e) {
                    LOG.completingSubCaseError(execution, e);
                    throw e;
                }
                catch (Exception e) {
                    LOG.completingSubCaseError(execution, e);
                    throw LOG.completingSubCaseErrorException(execution, e);
                }
            }
            execution.setSuperCaseExecution(null);
            execution.setSuperExecution(null);
        }
        CmmnExecution parent = execution.getParent();
        if (parent != null && (behavior = ActivityBehaviorUtil.getActivityBehavior(parent)) instanceof CmmnCompositeActivityBehavior) {
            CmmnCompositeActivityBehavior compositeBehavior = (CmmnCompositeActivityBehavior)behavior;
            compositeBehavior.handleChildCompletion(parent, execution);
        }
    }

    protected abstract void triggerBehavior(CmmnActivityBehavior var1, CmmnExecution var2);
}

