/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.model.BaseCallableElement;
import org.camunda.bpm.engine.impl.core.model.CallableElementParameter;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class CallableElement
extends BaseCallableElement {
    protected ParameterValueProvider businessKeyValueProvider;
    protected List<CallableElementParameter> inputs = new ArrayList<CallableElementParameter>();
    protected List<CallableElementParameter> outputs = new ArrayList<CallableElementParameter>();

    public String getBusinessKey(VariableScope variableScope) {
        if (this.businessKeyValueProvider == null) {
            return null;
        }
        Object result = this.businessKeyValueProvider.getValue(variableScope);
        if (result != null && !(result instanceof String)) {
            throw new ClassCastException("Cannot cast '" + result + "' to String");
        }
        return (String)result;
    }

    public ParameterValueProvider getBusinessKeyValueProvider() {
        return this.businessKeyValueProvider;
    }

    public void setBusinessKeyValueProvider(ParameterValueProvider businessKeyValueProvider) {
        this.businessKeyValueProvider = businessKeyValueProvider;
    }

    public List<CallableElementParameter> getInputs() {
        return this.inputs;
    }

    public void addInput(CallableElementParameter input) {
        this.inputs.add(input);
    }

    public void addInputs(List<CallableElementParameter> inputs) {
        this.inputs.addAll(inputs);
    }

    public VariableMap getInputVariables(VariableScope variableScope) {
        List<CallableElementParameter> inputs = this.getInputs();
        return this.getVariables(inputs, variableScope);
    }

    public List<CallableElementParameter> getOutputs() {
        return this.outputs;
    }

    public void addOutput(CallableElementParameter output) {
        this.outputs.add(output);
    }

    public void addOutputs(List<CallableElementParameter> outputs) {
        this.outputs.addAll(outputs);
    }

    public VariableMap getOutputVariables(VariableScope variableScope) {
        List<CallableElementParameter> outputs = this.getOutputs();
        return this.getVariables(outputs, variableScope);
    }

    protected VariableMap getVariables(List<CallableElementParameter> params, VariableScope variableScope) {
        VariableMap result = Variables.createVariables();
        for (CallableElementParameter param : params) {
            if (param.isAllVariables()) {
                Map<String, Object> allVariables = variableScope.getVariables();
                result.putAll(allVariables);
                continue;
            }
            String targetVariableName = param.getTarget();
            Object value = param.getSource(variableScope);
            result.put(targetVariableName, value);
        }
        return result;
    }
}

