/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable.type;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.core.variable.type.AbstractValueTypeImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.FileValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.engine.variable.value.builder.FileValueBuilder;

public class FileValueTypeImpl
extends AbstractValueTypeImpl
implements FileValueType {
    private static final long serialVersionUID = 1L;
    public static final String VALUE_INFO_FILE_NAME = "filename";
    public static final String VALUE_INFO_FILE_MIME_TYPE = "mimeType";
    public static final String VALUE_INFO_FILE_ENCODING = "encoding";

    public FileValueTypeImpl() {
        super("file");
    }

    @Override
    public TypedValue createValue(Object value, Map<String, Object> valueInfo) {
        Object filename = valueInfo.get(VALUE_INFO_FILE_NAME);
        if (filename == null) {
            throw new IllegalArgumentException("Cannot create file without filename! Please set a name into ValueInfo with key filename");
        }
        FileValueBuilder builder = Variables.fileValue(filename.toString());
        if (value instanceof File) {
            builder.file((File)value);
        } else if (value instanceof InputStream) {
            builder.file((InputStream)value);
        } else if (value instanceof byte[]) {
            builder.file((byte[])value);
        } else if (value instanceof String) {
            builder.file(Base64.decodeBase64(value.toString()));
        }
        if (valueInfo.containsKey(VALUE_INFO_FILE_MIME_TYPE)) {
            builder.mimeType(valueInfo.get(VALUE_INFO_FILE_MIME_TYPE).toString());
        }
        if (valueInfo.containsKey(VALUE_INFO_FILE_ENCODING)) {
            builder.encoding(valueInfo.get(VALUE_INFO_FILE_ENCODING).toString());
        }
        return builder.create();
    }

    @Override
    public Map<String, Object> getValueInfo(TypedValue typedValue) {
        if (!(typedValue instanceof FileValue)) {
            throw new IllegalArgumentException("Value not of type FileValue");
        }
        FileValue fileValue = (FileValue)typedValue;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put(VALUE_INFO_FILE_NAME, fileValue.getFilename());
        if (fileValue.getMimeType() != null) {
            result.put(VALUE_INFO_FILE_MIME_TYPE, fileValue.getMimeType());
        }
        if (fileValue.getEncoding() != null) {
            result.put(VALUE_INFO_FILE_ENCODING, fileValue.getEncoding());
        }
        return result;
    }

    @Override
    public boolean isPrimitiveValueType() {
        return true;
    }
}

