/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.camunda.bpm.engine.variable.type.FileValueType;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;

public class FileValueImpl
implements FileValue {
    private static final long serialVersionUID = 1L;
    protected String mimeType;
    protected String filename;
    protected byte[] value;
    protected FileValueType type;
    protected String encoding;

    public FileValueImpl(byte[] value, FileValueType type, String filename, String mimeType, String encoding) {
        this.value = value;
        this.type = type;
        this.filename = filename;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public FileValueImpl(FileValueType type, String filename) {
        this(null, type, filename, null, null);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setValue(byte[] bytes) {
        this.value = bytes;
    }

    @Override
    public InputStream getValue() {
        if (this.value == null) {
            return null;
        }
        return new ByteArrayInputStream(this.value);
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding.name();
    }

    @Override
    public Charset getEncodingAsCharset() {
        if (this.encoding == null) {
            return null;
        }
        return Charset.forName(this.encoding);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getByteArray() {
        return this.value;
    }

    public String toString() {
        return "FileValueImpl [mimeType=" + this.mimeType + ", filename=" + this.filename + ", type=" + this.type + "]";
    }
}

