/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionDefinitionCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.repository.DecisionDefinition;

public class GetDeploymentDecisionDiagramCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(GetDeploymentDecisionDiagramCmd.class.getName());
    protected String decisionDefinitionId;

    public GetDeploymentDecisionDiagramCmd(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @Override
    public InputStream execute(final CommandContext commandContext) {
        DecisionDefinition decisionDefinition = new GetDeploymentDecisionDefinitionCmd(this.decisionDefinitionId).execute(commandContext);
        final String deploymentId = decisionDefinition.getDeploymentId();
        final String resourceName = decisionDefinition.getDiagramResourceName();
        if (resourceName == null) {
            log.info("Resource name is null! No decision diagram stream exists.");
            return null;
        }
        return commandContext.runWithoutAuthorization(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
            }
        });
    }
}

