/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import org.camunda.bpm.engine.exception.dmn.DmnModelInstanceNotFoundException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.model.dmn.DmnModelInstance;

public class GetDeploymentDmnModelInstanceCmd
implements Command<DmnModelInstance> {
    protected String decisionDefinitionId;

    public GetDeploymentDmnModelInstanceCmd(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @Override
    public DmnModelInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)this.decisionDefinitionId);
        DmnModelInstance modelInstance = Context.getProcessEngineConfiguration().getDeploymentCache().findDmnModelInstanceForDecisionDefinition(this.decisionDefinitionId);
        EnsureUtil.ensureNotNull(DmnModelInstanceNotFoundException.class, "No DMN model instance found for decision definition id " + this.decisionDefinitionId, "modelInstance", (Object)modelInstance);
        return modelInstance;
    }
}

