/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.parser;

import org.camunda.bpm.dmn.engine.DmnDecisionTable;
import org.camunda.bpm.dmn.engine.DmnDecisionTableListener;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.repository.DecisionDefinition;

public class HistoryDecisionTableListener
implements DmnDecisionTableListener {
    protected DmnHistoryEventProducer eventProducer;
    protected HistoryLevel historyLevel;

    public HistoryDecisionTableListener(DmnHistoryEventProducer historyEventProducer, HistoryLevel historyLevel) {
        this.eventProducer = historyEventProducer;
        this.historyLevel = historyLevel;
    }

    public void notify(DmnDecisionTable decisionTable, DmnDecisionTableResult decisionTableResult) {
        ExecutionEntity execution = (ExecutionEntity)Context.getBpmnExecutionContext().getExecution();
        HistoryEvent historyEvent = this.createHistoryEvent(execution, decisionTable, decisionTableResult);
        if (historyEvent != null) {
            Context.getProcessEngineConfiguration().getHistoryEventHandler().handleEvent(historyEvent);
        }
    }

    public HistoryEvent createHistoryEvent(DelegateExecution execution, DmnDecisionTable decisionTable, DmnDecisionTableResult decisionTableResult) {
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.DMN_DECISION_EVALUATE, null) && this.isDeployedDecisionTable(decisionTable)) {
            return this.eventProducer.createDecisionEvaluatedEvt(execution, decisionTable, decisionTableResult);
        }
        return null;
    }

    protected boolean isDeployedDecisionTable(DmnDecisionTable decisionTable) {
        if (decisionTable instanceof DecisionDefinition) {
            return ((DecisionDefinition)decisionTable).getId() != null;
        }
        return false;
    }
}

