/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.producer;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.dmn.engine.DmnDecisionTable;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableRule;
import org.camunda.bpm.dmn.engine.DmnDecisionTableValue;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DefaultDmnHistoryEventProducer
implements DmnHistoryEventProducer {
    @Override
    public HistoryEvent createDecisionEvaluatedEvt(DelegateExecution execution, DmnDecisionTable decisionTable, DmnDecisionTableResult decisionTableResult) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(executionEntity, decisionTable, decisionTableResult);
        this.initDecisionInstanceEvent(event, executionEntity, decisionTable, decisionTableResult, HistoryEventTypes.DMN_DECISION_EVALUATE);
        event.setEvaluationTime(ClockUtil.getCurrentTime());
        return event;
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(ExecutionEntity executionEntity, DmnDecisionTable decisionTable, DmnDecisionTableResult decisionTableResult) {
        return new HistoricDecisionInstanceEntity();
    }

    protected void initDecisionInstanceEvent(HistoricDecisionInstanceEntity event, ExecutionEntity execution, DmnDecisionTable decisionTable, DmnDecisionTableResult decisionTableResult, HistoryEventTypes eventType) {
        event.setEventType(eventType.getEventName());
        event.setDecisionDefinitionId(((DecisionDefinition)decisionTable).getId());
        event.setDecisionDefinitionKey(decisionTable.getKey());
        event.setDecisionDefinitionName(decisionTable.getName());
        event.setProcessDefinitionKey(this.getProcessDefinitionKey(execution));
        event.setProcessDefinitionId(execution.getProcessDefinitionId());
        event.setProcessInstanceId(execution.getProcessInstanceId());
        event.setActivityId(execution.getActivityId());
        event.setActivityInstanceId(execution.getActivityInstanceId());
        if (decisionTableResult.getCollectResultValue() != null) {
            double collectResultValue = decisionTableResult.getCollectResultValue().doubleValue();
            event.setCollectResultValue(collectResultValue);
        }
        List<HistoricDecisionInputInstance> historicDecisionInputInstances = this.createHistoricDecisionInputInstances(decisionTableResult);
        event.setInputs(historicDecisionInputInstances);
        List<HistoricDecisionOutputInstance> historicDecisionOutputInstances = this.createHistoricDecisionOutputInstances(decisionTableResult);
        event.setOutputs(historicDecisionOutputInstances);
    }

    protected String getProcessDefinitionKey(ExecutionEntity execution) {
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)execution.getProcessDefinition();
        if (definition != null) {
            return definition.getKey();
        }
        return null;
    }

    protected List<HistoricDecisionInputInstance> createHistoricDecisionInputInstances(DmnDecisionTableResult decisionTableResult) {
        ArrayList<HistoricDecisionInputInstance> inputInstances = new ArrayList<HistoricDecisionInputInstance>();
        for (DmnDecisionTableValue inputClause : decisionTableResult.getInputs().values()) {
            HistoricDecisionInputInstanceEntity inputInstance = new HistoricDecisionInputInstanceEntity();
            inputInstance.setClauseId(inputClause.getKey());
            inputInstance.setClauseName(inputClause.getName());
            TypedValue typedValue = Variables.untypedValue(inputClause.getValue());
            inputInstance.setValue(typedValue);
            inputInstances.add(inputInstance);
        }
        return inputInstances;
    }

    protected List<HistoricDecisionOutputInstance> createHistoricDecisionOutputInstances(DmnDecisionTableResult decisionTableResult) {
        ArrayList<HistoricDecisionOutputInstance> outputInstances = new ArrayList<HistoricDecisionOutputInstance>();
        List matchingRules = decisionTableResult.getMatchingRules();
        for (int index = 0; index < matchingRules.size(); ++index) {
            DmnDecisionTableRule rule = (DmnDecisionTableRule)matchingRules.get(index);
            String ruleId = rule.getKey();
            Integer ruleOrder = index + 1;
            for (DmnDecisionTableValue outputClause : rule.getOutputs().values()) {
                HistoricDecisionOutputInstanceEntity outputInstance = new HistoricDecisionOutputInstanceEntity();
                outputInstance.setClauseId(outputClause.getKey());
                outputInstance.setClauseName(outputClause.getName());
                outputInstance.setRuleId(ruleId);
                outputInstance.setRuleOrder(ruleOrder);
                outputInstance.setVariableName(outputClause.getOutputName());
                TypedValue typedValue = Variables.untypedValue(outputClause.getValue());
                outputInstance.setValue(typedValue);
                outputInstances.add(outputInstance);
            }
        }
        return outputInstances;
    }
}

