/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.BpmnStackTrace;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class AtomicOperationInvocation {
    private static Logger log = Logger.getLogger(CommandContext.class.getName());
    protected AtomicOperation operation;
    protected ExecutionEntity execution;
    protected boolean performAsync;
    protected String applicationContextName = null;
    protected String activityId = null;

    public AtomicOperationInvocation(AtomicOperation operation, ExecutionEntity execution, boolean performAsync) {
        this.init(operation, execution, performAsync);
    }

    protected void init(AtomicOperation operation, ExecutionEntity execution, boolean performAsync) {
        this.operation = operation;
        this.execution = execution;
        this.performAsync = performAsync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(BpmnStackTrace stackTrace) {
        ExecutionEntity replacedBy;
        if (this.operation != PvmAtomicOperation.ACTIVITY_START_CANCEL_SCOPE && this.operation != PvmAtomicOperation.ACTIVITY_START_INTERRUPT_SCOPE && (replacedBy = this.execution.getReplacedBy()) != null) {
            this.execution = replacedBy;
        }
        if (this.execution.isEnded() && (this.operation == PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE || this.operation == PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE)) {
            return;
        }
        ProcessApplicationReference currentPa = Context.getCurrentProcessApplication();
        if (currentPa != null) {
            this.applicationContextName = currentPa.getName();
        }
        this.activityId = this.execution.getActivityId();
        stackTrace.add(this);
        try {
            Context.setExecutionContext(this.execution);
            if (!this.performAsync) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("AtomicOperation: " + this.operation + " on " + this.execution);
                }
                this.operation.execute(this.execution);
            } else {
                this.execution.scheduleAtomicOperationAsync(this.operation);
            }
        }
        finally {
            Context.removeExecutionContext();
        }
    }

    public AtomicOperation getOperation() {
        return this.operation;
    }

    public ExecutionEntity getExecution() {
        return this.execution;
    }

    public boolean isPerformAsync() {
        return this.performAsync;
    }

    public String getApplicationContextName() {
        return this.applicationContextName;
    }

    public String getActivityId() {
        return this.activityId;
    }
}

