/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.interceptor.AtomicOperationInvocation;

public class BpmnStackTrace {
    public static final Logger log = Logger.getLogger(BpmnStackTrace.class.getName());
    protected List<AtomicOperationInvocation> perfromedInvocations = new ArrayList<AtomicOperationInvocation>();

    public void printStackTrace(boolean verbose) {
        if (this.perfromedInvocations.isEmpty()) {
            return;
        }
        StringWriter writer = new StringWriter();
        writer.write("BPMN Stack Trace:\n");
        if (!verbose) {
            this.logNonVerbose(writer);
        } else {
            this.logVerbose(writer);
        }
        log.severe(writer.toString());
        this.perfromedInvocations.clear();
    }

    protected void logNonVerbose(StringWriter writer) {
        this.writeInvocation(this.perfromedInvocations.get(this.perfromedInvocations.size() - 1), writer);
        List<String> activities = this.collectActivityTrace();
        this.logActivityTrace(writer, activities);
    }

    protected void logVerbose(StringWriter writer) {
        Collections.reverse(this.perfromedInvocations);
        for (AtomicOperationInvocation invocation : this.perfromedInvocations) {
            this.writeInvocation(invocation, writer);
        }
    }

    protected void logActivityTrace(StringWriter writer, List<String> activities) {
        for (int i = 0; i < activities.size(); ++i) {
            if (i != 0) {
                writer.write("\t  ^\n");
                writer.write("\t  |\n");
            }
            writer.write("\t");
            writer.write(activities.get(i));
            writer.write("\n");
        }
    }

    protected List<String> collectActivityTrace() {
        ArrayList<String> activities = new ArrayList<String>();
        for (AtomicOperationInvocation atomicOperationInvocation : this.perfromedInvocations) {
            String activityId = atomicOperationInvocation.getActivityId();
            if (activityId == null || !activities.isEmpty() && activityId.equals(activities.get(0))) continue;
            activities.add(0, activityId);
        }
        return activities;
    }

    public void add(AtomicOperationInvocation atomicOperationInvocation) {
        this.perfromedInvocations.add(atomicOperationInvocation);
    }

    protected void writeInvocation(AtomicOperationInvocation invocation, StringWriter writer) {
        writer.write("\t");
        writer.write(invocation.getActivityId());
        writer.write(" (");
        writer.write(invocation.getOperation().getCanonicalName());
        writer.write(", ");
        writer.write(invocation.getExecution().toString());
        if (invocation.isPerformAsync()) {
            writer.write(", ASYNC");
        }
        if (invocation.getApplicationContextName() != null) {
            writer.write(", pa=");
            writer.write(invocation.getApplicationContextName());
        }
        writer.write(")\n");
    }
}

