/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;

public abstract class AcquireJobsRunnable
implements Runnable {
    private static Logger log = Logger.getLogger(AcquireJobsRunnable.class.getName());
    protected final JobExecutor jobExecutor;
    protected volatile boolean isInterrupted = false;
    protected volatile boolean isJobAdded = false;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public AcquireJobsRunnable(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendAcquisition(long millis) {
        if (millis <= 0L) {
            return;
        }
        try {
            log.fine("job acquisition thread sleeping for " + millis + " millis");
            Object object = this.MONITOR;
            synchronized (object) {
                if (!this.isInterrupted) {
                    this.isWaiting.set(true);
                    this.MONITOR.wait(millis);
                }
            }
            log.fine("job acquisition thread woke up");
            this.isJobAdded = false;
        }
        catch (InterruptedException e) {
            log.fine("job acquisition wait interrupted");
        }
        finally {
            this.isWaiting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        this.isJobAdded = true;
        if (this.isWaiting.compareAndSet(true, false)) {
            Object object = this.MONITOR;
            synchronized (object) {
                this.MONITOR.notifyAll();
            }
        }
    }

    public boolean isJobAdded() {
        return this.isJobAdded;
    }
}

