/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.jobexecutor.ThreadPoolJobExecutor;

public class DefaultJobExecutor
extends ThreadPoolJobExecutor {
    private static Logger log = Logger.getLogger(DefaultJobExecutor.class.getName());
    protected int queueSize = 3;
    protected int corePoolSize = 3;
    protected int maxPoolSize = 10;

    @Override
    protected void startExecutingJobs() {
        if (this.threadPoolExecutor == null || this.threadPoolExecutor.isShutdown()) {
            ArrayBlockingQueue<Runnable> threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 0L, TimeUnit.MILLISECONDS, threadPoolQueue);
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        }
        super.startExecutingJobs();
    }

    @Override
    protected void stopExecutingJobs() {
        super.stopExecutingJobs();
        this.threadPoolExecutor.shutdown();
        try {
            if (!this.threadPoolExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.log(Level.WARNING, "Timeout during shutdown of job executor. The current running jobs could not end within 60 seconds after shutdown operation.");
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted while shutting down the job executor. ", e);
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }
}

