/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.AcquireJobsCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.AcquireJobsRunnable;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultAcquireJobsCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobsRunnable;
import org.camunda.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.SequentialJobAcquisitionRunnable;

public abstract class JobExecutor {
    private static Logger log = Logger.getLogger(JobExecutor.class.getName());
    protected String name = "JobExecutor[" + this.getClass().getName() + "]";
    protected List<ProcessEngineImpl> processEngines = new CopyOnWriteArrayList<ProcessEngineImpl>();
    protected AcquireJobsCommandFactory acquireJobsCmdFactory;
    protected AcquireJobsRunnable acquireJobsRunnable;
    protected RejectedJobsHandler rejectedJobsHandler;
    protected Thread jobAcquisitionThread;
    protected boolean isAutoActivate = false;
    protected boolean isActive = false;
    protected int maxJobsPerAcquisition = 3;
    protected int waitTimeInMillis = 5000;
    protected float waitIncreaseFactor = 2.0f;
    protected long maxWait = 60000L;
    protected int backoffTimeInMillis = 0;
    protected long maxBackoff = 0L;
    protected int backoffDecreaseThreshold = 100;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int lockTimeInMillis = 300000;

    public void start() {
        if (this.isActive) {
            return;
        }
        log.info("Starting up the JobExecutor[" + this.getClass().getName() + "].");
        this.ensureInitialization();
        this.startExecutingJobs();
        this.isActive = true;
    }

    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        log.info("Shutting down the JobExecutor[" + this.getClass().getName() + "].");
        this.acquireJobsRunnable.stop();
        this.stopExecutingJobs();
        this.ensureCleanup();
        this.isActive = false;
    }

    protected void ensureInitialization() {
        this.acquireJobsCmdFactory = new DefaultAcquireJobsCommandFactory(this);
        this.acquireJobsRunnable = new SequentialJobAcquisitionRunnable(this);
    }

    protected void ensureCleanup() {
        this.acquireJobsCmdFactory = null;
        this.acquireJobsRunnable = null;
    }

    public void jobWasAdded() {
        if (this.isActive) {
            this.acquireJobsRunnable.jobWasAdded();
        }
    }

    public synchronized void registerProcessEngine(ProcessEngineImpl processEngine) {
        this.processEngines.add(processEngine);
        if (this.processEngines.size() == 1 && this.isAutoActivate) {
            this.start();
        }
    }

    public synchronized void unregisterProcessEngine(ProcessEngineImpl processEngine) {
        this.processEngines.remove(processEngine);
        if (this.processEngines.isEmpty() && this.isActive) {
            this.shutdown();
        }
    }

    protected abstract void startExecutingJobs();

    protected abstract void stopExecutingJobs();

    public abstract void executeJobs(List<String> var1, ProcessEngineImpl var2);

    @Deprecated
    public void executeJobs(List<String> jobIds) {
        if (!this.processEngines.isEmpty()) {
            this.executeJobs(jobIds, this.processEngines.get(0));
        }
    }

    public void logAcquisitionAttempt(ProcessEngineImpl engine) {
        if (engine.getProcessEngineConfiguration().isMetricsEnabled()) {
            engine.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-acquisition-attempt");
        }
    }

    public void logAcquiredJobs(ProcessEngineImpl engine, int numJobs) {
        if (engine != null && engine.getProcessEngineConfiguration().isMetricsEnabled()) {
            engine.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-acquired-success", numJobs);
        }
    }

    public void logAcquisitionFailureJobs(ProcessEngineImpl engine, int numJobs) {
        if (engine != null && engine.getProcessEngineConfiguration().isMetricsEnabled()) {
            engine.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-acquired-failure", numJobs);
        }
    }

    public void logRejectedExecution(ProcessEngineImpl engine, int numJobs) {
        if (engine != null && engine.getProcessEngineConfiguration().isMetricsEnabled()) {
            engine.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-execution-rejected", numJobs);
        }
    }

    public List<ProcessEngineImpl> getProcessEngines() {
        return this.processEngines;
    }

    public Iterator<ProcessEngineImpl> engineIterator() {
        return this.processEngines.iterator();
    }

    public boolean hasRegisteredEngine(ProcessEngineImpl engine) {
        return this.processEngines.contains(engine);
    }

    @Deprecated
    public CommandExecutor getCommandExecutor() {
        if (this.processEngines.isEmpty()) {
            return null;
        }
        return this.processEngines.get(0).getProcessEngineConfiguration().getCommandExecutorTxRequired();
    }

    @Deprecated
    public void setCommandExecutor(CommandExecutor commandExecutorTxRequired) {
    }

    public int getWaitTimeInMillis() {
        return this.waitTimeInMillis;
    }

    public void setWaitTimeInMillis(int waitTimeInMillis) {
        this.waitTimeInMillis = waitTimeInMillis;
    }

    public int getBackoffTimeInMillis() {
        return this.backoffTimeInMillis;
    }

    public void setBackoffTimeInMillis(int backoffTimeInMillis) {
        this.backoffTimeInMillis = backoffTimeInMillis;
    }

    public int getLockTimeInMillis() {
        return this.lockTimeInMillis;
    }

    public void setLockTimeInMillis(int lockTimeInMillis) {
        this.lockTimeInMillis = lockTimeInMillis;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    public void setProcessEngines(List<ProcessEngineImpl> processEngines) {
        this.processEngines = processEngines;
    }

    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    public int getMaxJobsPerAcquisition() {
        return this.maxJobsPerAcquisition;
    }

    public void setMaxJobsPerAcquisition(int maxJobsPerAcquisition) {
        this.maxJobsPerAcquisition = maxJobsPerAcquisition;
    }

    public float getWaitIncreaseFactor() {
        return this.waitIncreaseFactor;
    }

    public void setWaitIncreaseFactor(float waitIncreaseFactor) {
        this.waitIncreaseFactor = waitIncreaseFactor;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public long getMaxBackoff() {
        return this.maxBackoff;
    }

    public void setMaxBackoff(long maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    public int getBackoffDecreaseThreshold() {
        return this.backoffDecreaseThreshold;
    }

    public void setBackoffDecreaseThreshold(int backoffDecreaseThreshold) {
        this.backoffDecreaseThreshold = backoffDecreaseThreshold;
    }

    public String getName() {
        return this.name;
    }

    public Command<AcquiredJobs> getAcquireJobsCmd(int numJobs) {
        return this.acquireJobsCmdFactory.getCommand(numJobs);
    }

    public AcquireJobsCommandFactory getAcquireJobsCmdFactory() {
        return this.acquireJobsCmdFactory;
    }

    public void setAcquireJobsCmdFactory(AcquireJobsCommandFactory acquireJobsCmdFactory) {
        this.acquireJobsCmdFactory = acquireJobsCmdFactory;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public RejectedJobsHandler getRejectedJobsHandler() {
        return this.rejectedJobsHandler;
    }

    public void setRejectedJobsHandler(RejectedJobsHandler rejectedJobsHandler) {
        this.rejectedJobsHandler = rejectedJobsHandler;
    }

    protected void startJobAcquisitionThread() {
        if (this.jobAcquisitionThread == null) {
            this.jobAcquisitionThread = new Thread((Runnable)this.acquireJobsRunnable, this.getName());
            this.jobAcquisitionThread.start();
        }
    }

    protected void stopJobAcquisitionThread() {
        try {
            this.jobAcquisitionThread.join();
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted while waiting for the job Acquisition thread to terminate", e);
        }
        this.jobAcquisitionThread = null;
    }

    public AcquireJobsRunnable getAcquireJobsRunnable() {
        return this.acquireJobsRunnable;
    }

    public Runnable getExecuteJobsRunnable(List<String> jobIds, ProcessEngineImpl processEngine) {
        return new ExecuteJobsRunnable(jobIds, processEngine);
    }
}

