/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.AcquireJobsRunnable;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.BackoffJobAcquisitionStrategy;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionStrategy;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;

public class SequentialJobAcquisitionRunnable
extends AcquireJobsRunnable {
    private static Logger log = Logger.getLogger(SequentialJobAcquisitionRunnable.class.getName());
    protected JobAcquisitionContext acquisitionContext = this.initializeAcquisitionContext();

    public SequentialJobAcquisitionRunnable(JobExecutor jobExecutor) {
        super(jobExecutor);
    }

    @Override
    public synchronized void run() {
        log.info(this.jobExecutor.getName() + " starting to acquire jobs");
        JobAcquisitionStrategy acquisitionStrategy = this.initializeAcquisitionStrategy();
        while (!this.isInterrupted) {
            this.acquisitionContext.reset();
            this.acquisitionContext.setAcquisitionTime(System.currentTimeMillis());
            Iterator<ProcessEngineImpl> engineIterator = this.jobExecutor.engineIterator();
            try {
                while (engineIterator.hasNext()) {
                    ProcessEngineImpl currentProcessEngine = engineIterator.next();
                    if (!this.jobExecutor.hasRegisteredEngine(currentProcessEngine)) continue;
                    AcquiredJobs acquiredJobs = this.acquireJobs(this.acquisitionContext, acquisitionStrategy, currentProcessEngine);
                    this.executeJobs(this.acquisitionContext, currentProcessEngine, acquiredJobs);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "exception during job acquisition: " + e.getMessage(), e);
                this.acquisitionContext.setAcquisitionException(e);
            }
            this.acquisitionContext.setJobAdded(this.isJobAdded);
            this.configureNextAcquisitionCycle(this.acquisitionContext, acquisitionStrategy);
            long waitTime = acquisitionStrategy.getWaitTime();
            waitTime = Math.max(0L, this.acquisitionContext.getAcquisitionTime() + waitTime - System.currentTimeMillis());
            this.suspendAcquisition(waitTime);
        }
        log.info(this.jobExecutor.getName() + " stopped job acquisition");
    }

    protected JobAcquisitionContext initializeAcquisitionContext() {
        return new JobAcquisitionContext();
    }

    protected void configureNextAcquisitionCycle(JobAcquisitionContext acquisitionContext, JobAcquisitionStrategy acquisitionStrategy) {
        acquisitionStrategy.reconfigure(acquisitionContext);
    }

    protected JobAcquisitionStrategy initializeAcquisitionStrategy() {
        return new BackoffJobAcquisitionStrategy(this.jobExecutor);
    }

    public JobAcquisitionContext getAcquisitionContext() {
        return this.acquisitionContext;
    }

    protected void executeJobs(JobAcquisitionContext context, ProcessEngineImpl currentProcessEngine, AcquiredJobs acquiredJobs) {
        List<List<String>> additionalJobs = context.getAdditionalJobsByEngine().get(currentProcessEngine.getName());
        if (additionalJobs != null) {
            for (List<String> jobBatch : additionalJobs) {
                this.jobExecutor.executeJobs(jobBatch, currentProcessEngine);
            }
        }
        for (List<String> jobIds : acquiredJobs.getJobIdBatches()) {
            this.jobExecutor.executeJobs(jobIds, currentProcessEngine);
        }
    }

    protected AcquiredJobs acquireJobs(JobAcquisitionContext context, JobAcquisitionStrategy acquisitionStrategy, ProcessEngineImpl currentProcessEngine) {
        CommandExecutor commandExecutor = currentProcessEngine.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        int numJobsToAcquire = acquisitionStrategy.getNumJobsToAcquire(currentProcessEngine.getName());
        AcquiredJobs acquiredJobs = null;
        if (numJobsToAcquire > 0) {
            this.jobExecutor.logAcquisitionAttempt(currentProcessEngine);
            acquiredJobs = commandExecutor.execute(this.jobExecutor.getAcquireJobsCmd(numJobsToAcquire));
        } else {
            acquiredJobs = new AcquiredJobs(numJobsToAcquire);
        }
        context.submitAcquiredJobs(currentProcessEngine.getName(), acquiredJobs);
        this.jobExecutor.logAcquiredJobs(currentProcessEngine, acquiredJobs.size());
        this.jobExecutor.logAcquisitionFailureJobs(currentProcessEngine, acquiredJobs.getNumberOfJobsFailedToLock());
        return acquiredJobs;
    }
}

