/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.metrics;

import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.metrics.MetricsReporterIdProvider;

public class SimpleIpBasedProvider
implements MetricsReporterIdProvider {
    private static Logger log = Logger.getLogger(SimpleIpBasedProvider.class.getName());

    @Override
    public String provideId(ProcessEngine processEngine) {
        String localIp;
        block2: {
            localIp = "";
            try {
                localIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.WARNING)) break block2;
                log.log(Level.WARNING, "Could not determine local IP address for generating an engine id", e);
            }
        }
        return SimpleIpBasedProvider.createId(localIp, processEngine.getName());
    }

    public static final String createId(String ip, String engineName) {
        return ip + "$" + engineName;
    }
}

