/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.EventSubscriptionJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.EventSubscription;

public abstract class EventSubscriptionEntity
implements EventSubscription,
DbEntity,
HasDbRevision,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision = 1;
    protected String eventType;
    protected String eventName;
    protected String executionId;
    protected String processInstanceId;
    protected String activityId;
    protected String configuration;
    protected Date created = ClockUtil.getCurrentTime();
    protected ExecutionEntity execution;
    protected ActivityImpl activity;
    protected EventSubscriptionJobDeclaration jobDeclaration;

    public EventSubscriptionEntity() {
    }

    public EventSubscriptionEntity(ExecutionEntity executionEntity) {
        this();
        this.setExecution(executionEntity);
        this.setActivity(this.execution.getActivity());
        this.processInstanceId = executionEntity.getProcessInstanceId();
    }

    public void eventReceived(Serializable payload, boolean processASync) {
        if (processASync) {
            this.scheduleEventAsync(payload);
        } else {
            this.processEventSync(payload);
        }
    }

    protected void processEventSync(Object payload) {
        EventHandler eventHandler = Context.getProcessEngineConfiguration().getEventHandler(this.eventType);
        EnsureUtil.ensureNotNull("Could not find eventhandler for event of type '" + this.eventType + "'", "eventHandler", (Object)eventHandler);
        eventHandler.handleEvent(this, payload, Context.getCommandContext());
    }

    protected void scheduleEventAsync(Serializable payload) {
        EventSubscriptionJobDeclaration asyncDeclaration = this.getJobDeclaration();
        if (asyncDeclaration == null) {
            this.processEventSync(payload);
        } else {
            MessageEntity message = (MessageEntity)asyncDeclaration.createJobInstance(this);
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getJobManager().send(message);
        }
    }

    public void delete() {
        Context.getCommandContext().getEventSubscriptionManager().deleteEventSubscription(this);
        this.removeFromExecution();
    }

    public void insert() {
        Context.getCommandContext().getEventSubscriptionManager().insert(this);
        this.addToExecution();
    }

    protected void addToExecution() {
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            execution.addEventSubscription(this);
        }
    }

    protected void removeFromExecution() {
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            execution.removeEventSubscription(this);
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("executionId", this.executionId);
        persistentState.put("configuration", this.configuration);
        return persistentState;
    }

    public ExecutionEntity getExecution() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
        if (execution != null) {
            this.executionId = execution.getId();
        }
    }

    public ActivityImpl getActivity() {
        if (this.activity == null && this.activityId != null) {
            ProcessDefinitionEntity processDefinition = this.getProcessDefinition();
            this.activity = processDefinition.findActivity(this.activityId);
        }
        return this.activity;
    }

    public ProcessDefinitionEntity getProcessDefinition() {
        if (this.executionId != null) {
            ExecutionEntity execution = this.getExecution();
            return (ProcessDefinitionEntity)execution.getProcessDefinition();
        }
        String processDefinitionId = this.getConfiguration();
        return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }

    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
        if (activity != null) {
            this.activityId = activity.getId();
        }
    }

    public EventSubscriptionJobDeclaration getJobDeclaration() {
        if (this.jobDeclaration == null) {
            this.jobDeclaration = EventSubscriptionJobDeclaration.findDeclarationForSubscription(this);
        }
        return this.jobDeclaration;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventSubscriptionEntity other = (EventSubscriptionEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", eventType=" + this.eventType + ", eventName=" + this.eventName + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", activityId=" + this.activityId + ", configuration=" + this.configuration + ", revision=" + this.revision + ", created=" + this.created + "]";
    }
}

