/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ProcessDefinitionManager
extends AbstractManager {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    public void insertProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.getDbEntityManager().insert(processDefinition);
        this.createDefaultAuthorizations(processDefinition);
    }

    public ProcessDefinitionEntity findLatestProcessDefinitionByKey(String processDefinitionKey) {
        return (ProcessDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestProcessDefinitionByKey", processDefinitionKey);
    }

    public ProcessDefinitionEntity findLatestProcessDefinitionById(String processDefinitionId) {
        return this.getDbEntityManager().selectById(ProcessDefinitionEntity.class, processDefinitionId);
    }

    public List<ProcessDefinition> findProcessDefinitionsByQueryCriteria(ProcessDefinitionQueryImpl processDefinitionQuery, Page page) {
        this.configureProcessDefinitionQuery(processDefinitionQuery);
        return this.getDbEntityManager().selectList("selectProcessDefinitionsByQueryCriteria", processDefinitionQuery, page);
    }

    public long findProcessDefinitionCountByQueryCriteria(ProcessDefinitionQueryImpl processDefinitionQuery) {
        this.configureProcessDefinitionQuery(processDefinitionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectProcessDefinitionCountByQueryCriteria", processDefinitionQuery);
    }

    public ProcessDefinitionEntity findProcessDefinitionByDeploymentAndKey(String deploymentId, String processDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("processDefinitionKey", processDefinitionKey);
        return (ProcessDefinitionEntity)this.getDbEntityManager().selectOne("selectProcessDefinitionByDeploymentAndKey", parameters);
    }

    public ProcessDefinition findProcessDefinitionByKeyAndVersion(String processDefinitionKey, Integer processDefinitionVersion) {
        ProcessDefinitionQueryImpl processDefinitionQuery = new ProcessDefinitionQueryImpl().processDefinitionKey(processDefinitionKey).processDefinitionVersion(processDefinitionVersion);
        List<ProcessDefinition> results = this.findProcessDefinitionsByQueryCriteria(processDefinitionQuery, null);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw LOG.toManyProcessDefinitionsException(results.size(), processDefinitionKey, processDefinitionVersion);
        }
        return null;
    }

    public List<ProcessDefinition> findProcessDefinitionsByKey(String processDefinitionKey) {
        ProcessDefinitionQueryImpl processDefinitionQuery = new ProcessDefinitionQueryImpl().processDefinitionKey(processDefinitionKey);
        return this.findProcessDefinitionsByQueryCriteria(processDefinitionQuery, null);
    }

    public List<ProcessDefinition> findProcessDefinitionsStartableByUser(String user) {
        return new ProcessDefinitionQueryImpl().startableByUser(user).list();
    }

    public List<User> findProcessDefinitionPotentialStarterUsers() {
        return null;
    }

    public List<Group> findProcessDefinitionPotentialStarterGroups() {
        return null;
    }

    public List<ProcessDefinition> findProcessDefinitionsByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectProcessDefinitionByDeploymentId", deploymentId);
    }

    public List<ProcessDefinition> findProcessDefinitionsByKeyIn(String ... keys) {
        return this.getDbEntityManager().selectList("selectProcessDefinitionByKeyIn", keys);
    }

    public void updateProcessDefinitionSuspensionStateById(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ProcessDefinitionEntity.class, "updateProcessDefinitionSuspensionStateByParameters", parameters);
    }

    public void updateProcessDefinitionSuspensionStateByKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ProcessDefinitionEntity.class, "updateProcessDefinitionSuspensionStateByParameters", parameters);
    }

    public void deleteProcessDefinitionsByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(ProcessDefinitionEntity.class, "deleteProcessDefinitionsByDeploymentId", deploymentId);
    }

    protected void createDefaultAuthorizations(ProcessDefinition processDefinition) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newProcessDefinition(processDefinition);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureProcessDefinitionQuery(ProcessDefinitionQueryImpl query) {
        this.getAuthorizationManager().configureProcessDefinitionQuery(query);
    }
}

