/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity.util;

import java.util.Arrays;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.value.UntypedValueImpl;
import org.camunda.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextListener;
import org.camunda.bpm.engine.impl.variable.serializer.ByteArrayValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class TypedValueField
implements DbEntityLifecycleAware,
CommandContextListener {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected String serializerName;
    protected TypedValueSerializer<?> serializer;
    protected TypedValue cachedValue;
    protected String errorMessage;
    protected final ValueFields valueFields;

    public TypedValueField(ValueFields valueFields) {
        this.valueFields = valueFields;
    }

    public Object getValue() {
        TypedValue typedValue = this.getTypedValue();
        if (typedValue != null) {
            return typedValue.getValue();
        }
        return null;
    }

    public TypedValue getTypedValue() {
        return this.getTypedValue(true);
    }

    public TypedValue getTypedValue(boolean deserializeValue) {
        if (this.cachedValue != null && this.cachedValue instanceof SerializableValue && Context.getCommandContext() != null) {
            SerializableValue serializableValue = (SerializableValue)this.cachedValue;
            if (deserializeValue && !serializableValue.isDeserialized()) {
                this.cachedValue = null;
            }
        }
        if (this.cachedValue == null && this.errorMessage == null) {
            try {
                this.cachedValue = this.getSerializer().readValue(this.valueFields, deserializeValue);
                if (this.isMutableValue(this.cachedValue)) {
                    Context.getCommandContext().registerCommandContextListener(this);
                }
            }
            catch (RuntimeException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
        return this.cachedValue;
    }

    public TypedValue setValue(TypedValue value) {
        this.serializer = TypedValueField.getSerializers().findSerializerForValue(value);
        this.serializerName = this.serializer.getName();
        if (value instanceof UntypedValueImpl) {
            value = this.serializer.convertToTypedValue((UntypedValueImpl)value);
        }
        this.writeValue(value);
        this.cachedValue = value;
        if (this.isMutableValue(this.cachedValue)) {
            Context.getCommandContext().registerCommandContextListener(this);
        }
        return value;
    }

    protected boolean isMutableValue(TypedValue value) {
        return this.serializer.isMutableValue(value);
    }

    protected void writeValue(TypedValue value) {
        this.serializer.writeValue(value, this.valueFields);
    }

    @Override
    public void onCommandContextClose(CommandContext commandContext) {
        this.updateFields();
    }

    @Override
    public void onCommandFailed(CommandContext commandContext, Throwable t) {
    }

    protected void updateFields() {
        if (this.cachedValue != null && this.isMutableValue(this.cachedValue)) {
            byte[] byteArray = ByteArrayValueSerializer.getBytes(this.valueFields);
            this.writeValue(this.cachedValue);
            byte[] byteArrayAfter = ByteArrayValueSerializer.getBytes(this.valueFields);
            if (Arrays.equals(byteArray, byteArrayAfter)) {
                ByteArrayValueSerializer.setBytes(this.valueFields, byteArray);
            }
        }
    }

    public TypedValueSerializer<?> getSerializer() {
        this.ensureSerializerInitialized();
        return this.serializer;
    }

    protected void ensureSerializerInitialized() {
        if (this.serializerName != null && this.serializer == null) {
            this.serializer = TypedValueField.getSerializers().getSerializerByName(this.serializerName);
            if (this.serializer == null) {
                throw LOG.serializerNotDefinedException(this);
            }
        }
    }

    public static VariableSerializers getSerializers() {
        if (Context.getCommandContext() != null) {
            return Context.getProcessEngineConfiguration().getVariableSerializers();
        }
        throw LOG.serializerOutOfContextException();
    }

    public String getSerializerName() {
        return this.serializerName;
    }

    public void setSerializerName(String serializerName) {
        this.serializerName = serializerName;
    }

    public String getTypeName() {
        if (this.serializerName == null) {
            return ValueType.NULL.getName();
        }
        return this.getSerializer().getType().getName();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void postLoad() {
        this.ensureSerializerInitialized();
    }

    public void clear() {
        this.cachedValue = null;
    }
}

