/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SequentialMultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.persistence.entity.ActivityInstanceImpl;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.ActivityAwareScopeExecutionCollector;
import org.camunda.bpm.engine.impl.tree.ExecutionWalker;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.ScopeCollector;

public class LegacyBehavior {
    private static final Logger log = Logger.getLogger(LegacyBehavior.class.getName());

    public static void pruneConcurrentScope(PvmExecutionImpl execution) {
        LegacyBehavior.ensureConcurrentScope(execution);
        log.fine("[LEGACY BEHAVIOR]: concurrent scope execution is pruned " + execution);
        execution.setConcurrent(false);
    }

    public static void cancelConcurrentScope(PvmExecutionImpl execution, PvmActivity cancelledScopeActivity) {
        LegacyBehavior.ensureConcurrentScope(execution);
        log.fine("[LEGACY BEHAVIOR]: cancel concurrent scope execution " + execution);
        execution.interrupt("Scope " + cancelledScopeActivity + " cancelled.");
        execution.setActivity(cancelledScopeActivity);
        execution.leaveActivityInstance();
        execution.interrupt("Scope " + cancelledScopeActivity + " cancelled.");
        execution.destroy();
    }

    public static void destroyConcurrentScope(PvmExecutionImpl execution) {
        LegacyBehavior.ensureConcurrentScope(execution);
        log.fine("[LEGACY BEHAVIOR]: destroy concurrent scope execution " + execution);
        execution.destroy();
    }

    public static boolean eventSubprocessComplete(ActivityExecution scopeExecution) {
        boolean performLegacyBehavior = LegacyBehavior.isLegacyBehaviorRequired(scopeExecution);
        if (performLegacyBehavior) {
            log.fine("[LEGACY BEHAVIOR]: complete non-scope event subprocess.");
            scopeExecution.end(false);
        }
        return performLegacyBehavior;
    }

    public static boolean eventSubprocessConcurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        boolean performLegacyBehavior = LegacyBehavior.isLegacyBehaviorRequired(endedExecution);
        if (performLegacyBehavior) {
            log.fine("[LEGACY BEHAVIOR]: end concurrent execution in event subprocess.");
            ScopeImpl flowScope = endedExecution.getActivity().getFlowScope();
            if (flowScope != null && (flowScope = flowScope.getFlowScope()) != null) {
                if (flowScope == endedExecution.getActivity().getProcessDefinition()) {
                    endedExecution.remove();
                    scopeExecution.tryPruneLastConcurrentChild();
                    scopeExecution.forceUpdate();
                } else {
                    PvmActivity flowScopeActivity = (PvmActivity)((Object)flowScope);
                    ActivityBehavior activityBehavior = flowScopeActivity.getActivityBehavior();
                    if (activityBehavior instanceof CompositeActivityBehavior) {
                        ((CompositeActivityBehavior)activityBehavior).concurrentChildExecutionEnded(scopeExecution, endedExecution);
                    }
                }
            }
        }
        return performLegacyBehavior;
    }

    public static boolean destroySecondNonScope(PvmExecutionImpl execution) {
        LegacyBehavior.ensureScope(execution);
        boolean performLegacyBehavior = LegacyBehavior.isLegacyBehaviorRequired(execution);
        if (performLegacyBehavior) {
            log.fine("[LEGACY BEHAVIOR]: end scope execution in previously non-scope activity");
        }
        return performLegacyBehavior;
    }

    protected static boolean isLegacyBehaviorRequired(ActivityExecution scopeExecution) {
        Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = scopeExecution.createActivityExecutionMapping();
        PvmScope activity = scopeExecution.getActivity();
        if (!activity.isScope()) {
            activity = activity.getFlowScope();
        }
        return activityExecutionMapping.get(activity) == activityExecutionMapping.get(activity.getFlowScope());
    }

    public static PvmExecutionImpl getScopeExecution(ScopeImpl scope, Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping) {
        ScopeImpl flowScope = scope.getFlowScope();
        return activityExecutionMapping.get(flowScope);
    }

    protected static void ensureConcurrentScope(PvmExecutionImpl execution) {
        LegacyBehavior.ensureScope(execution);
        LegacyBehavior.ensureConcurrent(execution);
    }

    protected static void ensureConcurrent(PvmExecutionImpl execution) {
        if (!execution.isConcurrent()) {
            throw new ProcessEngineException("Execution must be concurrent.");
        }
    }

    protected static void ensureScope(PvmExecutionImpl execution) {
        if (!execution.isScope()) {
            throw new ProcessEngineException("Execution must be scope.");
        }
    }

    public static Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping(List<PvmExecutionImpl> scopeExecutions, List<ScopeImpl> scopes) {
        PvmExecutionImpl deepestExecution = scopeExecutions.get(0);
        if (LegacyBehavior.isLegacyAsyncAtMultiInstance(deepestExecution)) {
            scopes.remove(0);
        }
        int numOfMissingExecutions = scopes.size() - scopeExecutions.size();
        Collections.reverse(scopeExecutions);
        Collections.reverse(scopes);
        HashMap<ScopeImpl, PvmExecutionImpl> mapping = new HashMap<ScopeImpl, PvmExecutionImpl>();
        mapping.put(scopes.get(0), scopeExecutions.get(0));
        int executionCounter = 0;
        for (int i = 1; i < scopes.size(); ++i) {
            ActivityImpl scope = (ActivityImpl)scopes.get(i);
            if (numOfMissingExecutions > 0 && LegacyBehavior.wasNoScope(scope)) {
                --numOfMissingExecutions;
            } else {
                ++executionCounter;
            }
            if (executionCounter >= scopeExecutions.size()) {
                throw new ProcessEngineException("Cannot construct activity-execution mapping: there are more scope executions missing than explained by the flow scope hierarchy.");
            }
            PvmExecutionImpl execution = scopeExecutions.get(executionCounter);
            mapping.put(scope, execution);
        }
        return mapping;
    }

    protected static boolean wasNoScope(ActivityImpl activity) {
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        ActivityBehavior parentActivityBehavior = (ActivityBehavior)(activity.getFlowScope() != null ? activity.getFlowScope().getActivityBehavior() : null);
        return activityBehavior instanceof EventSubProcessActivityBehavior || activityBehavior instanceof SubProcessActivityBehavior && parentActivityBehavior instanceof SequentialMultiInstanceActivityBehavior || activityBehavior instanceof ReceiveTaskActivityBehavior && parentActivityBehavior instanceof MultiInstanceActivityBehavior;
    }

    protected static boolean isLegacyAsyncAtMultiInstance(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            boolean isAsync = execution.getActivityInstanceId() == null;
            boolean isAtMultiInstance = activity.getParentFlowScopeActivity() != null && activity.getParentFlowScopeActivity().getActivityBehavior() instanceof MultiInstanceActivityBehavior;
            return isAsync && isAtMultiInstance;
        }
        return false;
    }

    public static PvmExecutionImpl determinePropagatingExecutionOnEnd(PvmExecutionImpl propagatingExecution) {
        if (!propagatingExecution.isScope()) {
            return propagatingExecution;
        }
        ScopeImpl flowScope = propagatingExecution.getActivity().getFlowScope();
        ActivityAwareScopeExecutionCollector scopeExecutionCollector = new ActivityAwareScopeExecutionCollector(flowScope);
        new ExecutionWalker(propagatingExecution).addPreVisitor(scopeExecutionCollector).walkUntil();
        List<PvmExecutionImpl> scopeExecutions = scopeExecutionCollector.getExecutions();
        ScopeCollector scopeCollector = new ScopeCollector();
        new FlowScopeWalker(flowScope).addPreVisitor(scopeCollector).walkUntil();
        List<ScopeImpl> flowScopes = scopeCollector.getScopes();
        if (scopeExecutions.size() > flowScopes.size()) {
            propagatingExecution.remove();
            PvmExecutionImpl parent = propagatingExecution.getParent();
            parent.setActivity(propagatingExecution.getActivity());
            return propagatingExecution.getParent();
        }
        return propagatingExecution;
    }

    public static boolean isConcurrentScope(PvmExecutionImpl propagatingExecution) {
        return propagatingExecution.isConcurrent() && propagatingExecution.isScope();
    }

    public static void removeLegacySubscriptionOnParent(ExecutionEntity execution, EventSubscriptionEntity eventSubscription) {
        ActivityImpl activity = execution.getActivity();
        if (activity == null) {
            return;
        }
        ActivityBehavior behavior = activity.getActivityBehavior();
        ActivityBehavior parentBehavior = (ActivityBehavior)(activity.getFlowScope() != null ? activity.getFlowScope().getActivityBehavior() : null);
        if (behavior instanceof ReceiveTaskActivityBehavior && parentBehavior instanceof MultiInstanceActivityBehavior) {
            List<EventSubscriptionEntity> parentSubscriptions = execution.getParent().getEventSubscriptions();
            for (EventSubscriptionEntity subscription : parentSubscriptions) {
                if (!LegacyBehavior.areEqualEventSubscriptions(subscription, eventSubscription)) continue;
                subscription.delete();
            }
        }
    }

    protected static boolean areEqualEventSubscriptions(EventSubscriptionEntity subscription1, EventSubscriptionEntity subscription2) {
        return LegacyBehavior.valuesEqual(subscription1.getEventType(), subscription2.getEventType()) && LegacyBehavior.valuesEqual(subscription1.getEventName(), subscription2.getEventName()) && LegacyBehavior.valuesEqual(subscription1.getActivityId(), subscription2.getActivityId());
    }

    protected static <T> boolean valuesEqual(T value1, T value2) {
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    public static void removeLegacyNonScopesFromMapping(Map<ScopeImpl, PvmExecutionImpl> mapping) {
        HashMap<PvmExecutionImpl, ArrayList<ScopeImpl>> scopesForExecutions = new HashMap<PvmExecutionImpl, ArrayList<ScopeImpl>>();
        for (Map.Entry<ScopeImpl, PvmExecutionImpl> entry : mapping.entrySet()) {
            ArrayList<ScopeImpl> scopesForExecution = (ArrayList<ScopeImpl>)scopesForExecutions.get(entry.getValue());
            if (scopesForExecution == null) {
                scopesForExecution = new ArrayList<ScopeImpl>();
                scopesForExecutions.put(entry.getValue(), scopesForExecution);
            }
            scopesForExecution.add(entry.getKey());
        }
        for (Map.Entry<ScopeImpl, PvmExecutionImpl> entry : scopesForExecutions.entrySet()) {
            List scopes = (List)((Object)entry.getValue());
            if (scopes.size() <= 1) continue;
            for (ScopeImpl scope : scopes) {
                ActivityImpl scopeActivity;
                if (scope == scope.getProcessDefinition() || !LegacyBehavior.wasNoScope(scopeActivity = (ActivityImpl)scope)) continue;
                mapping.remove(scope);
            }
        }
    }

    public static void repairParentRelationships(Collection<ActivityInstanceImpl> values, String processInstanceId) {
        for (ActivityInstanceImpl activityInstance : values) {
            if (!LegacyBehavior.valuesEqual(activityInstance.getId(), activityInstance.getParentActivityInstanceId())) continue;
            activityInstance.setParentActivityInstanceId(processInstanceId);
        }
    }

    public static void migrateMultiInstanceJobDefinitions(ProcessDefinitionEntity processDefinition, List<JobDefinitionEntity> jobDefinitions) {
        for (JobDefinitionEntity jobDefinition : jobDefinitions) {
            ActivityImpl activity;
            String activityId = jobDefinition.getActivityId();
            if (activityId == null || LegacyBehavior.isAsync(activity = processDefinition.findActivity(jobDefinition.getActivityId())) || !LegacyBehavior.isActivityWrappedInMultiInstanceBody(activity) || !LegacyBehavior.isAsyncJobDefinition(jobDefinition)) continue;
            jobDefinition.setActivityId(activity.getFlowScope().getId());
        }
    }

    protected static boolean isAsync(ActivityImpl activity) {
        return activity.isAsyncBefore() || activity.isAsyncAfter();
    }

    protected static boolean isAsyncJobDefinition(JobDefinitionEntity jobDefinition) {
        return "async-continuation".equals(jobDefinition.getJobType());
    }

    protected static boolean isActivityWrappedInMultiInstanceBody(ActivityImpl activity) {
        ScopeImpl flowScope = activity.getFlowScope();
        if (flowScope != activity.getProcessDefinition()) {
            ActivityImpl flowScopeActivity = (ActivityImpl)flowScope;
            return flowScopeActivity.getActivityBehavior() instanceof MultiInstanceActivityBehavior;
        }
        return false;
    }

    public static void repairMultiInstanceAsyncJob(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        if (!LegacyBehavior.isAsync(activity) && LegacyBehavior.isActivityWrappedInMultiInstanceBody(activity)) {
            execution.setActivity((ActivityImpl)activity.getFlowScope());
        }
    }

    public static boolean signalCancelBoundaryEvent(String signalName) {
        return "compensationDone".equals(signalName);
    }

    public static void parseCancelBoundaryEvent(ActivityImpl activity) {
        activity.setProperty("throwsCompensation", true);
    }
}

