/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.camunda.bpm.engine.impl.util.ActivityBehaviorUtil;

public class PvmAtomicOperationActivityExecute
implements PvmAtomicOperation {
    private static Logger log = Logger.getLogger(PvmAtomicOperationActivityExecute.class.getName());

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        ActivityBehavior activityBehavior = ActivityBehaviorUtil.getActivityBehavior(execution);
        ActivityImpl activity = execution.getActivity();
        log.fine(execution + " executes " + activity + ": " + activityBehavior.getClass().getName());
        try {
            activityBehavior.execute(execution);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't execute activity <" + activity.getProperty("type") + " id=\"" + activity.getId() + "\" ...>: " + e.getMessage(), e);
        }
    }

    @Override
    public String getCanonicalName() {
        return "activity-execute";
    }

    @Override
    public boolean isAsyncCapable() {
        return false;
    }
}

