/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.engine.ScriptEvaluationException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;

public class CompiledExecutableScript
extends ExecutableScript {
    private static final Logger LOG = Logger.getLogger(CompiledExecutableScript.class.getName());
    protected CompiledScript compiledScript;

    protected CompiledExecutableScript(String language) {
        this(language, null);
    }

    protected CompiledExecutableScript(String language, CompiledScript compiledScript) {
        super(language);
        this.compiledScript = compiledScript;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    @Override
    public Object evaluate(ScriptEngine scriptEngine, VariableScope variableScope, Bindings bindings) {
        try {
            LOG.fine("Evaluating compiled script using " + this.language + " script engine ");
            return this.getCompiledScript().eval(bindings);
        }
        catch (ScriptException e) {
            if (e.getCause() instanceof BpmnError) {
                throw (BpmnError)e.getCause();
            }
            throw new ScriptEvaluationException("Unable to evaluate script: " + e.getMessage(), e);
        }
    }
}

