/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.scriptengine.DmnCompiledScript;
import org.camunda.bpm.dmn.scriptengine.DmnScriptEngine;
import org.camunda.bpm.engine.ScriptCompilationException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.scripting.CompiledExecutableScript;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;

public class DmnExecutableScript
extends CompiledExecutableScript {
    protected DmnExecutableScript(DmnDecision decision) {
        super("dmn");
        this.compiledScript = this.compileDecision(decision);
    }

    protected DmnCompiledScript compileDecision(DmnDecision decision) {
        DmnScriptEngine dmnScriptEngine = this.getDmnScriptEngine();
        try {
            return dmnScriptEngine.compile(decision);
        }
        catch (ScriptException e) {
            throw new ScriptCompilationException("Unable to compile decision '" + decision.getKey() + "': " + e.getMessage(), e);
        }
    }

    protected DmnScriptEngine getDmnScriptEngine() {
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        ScriptEngine scriptEngine = scriptingEngines.getScriptEngineForLanguage(this.language);
        if (scriptEngine != null) {
            return (DmnScriptEngine)scriptEngine;
        }
        throw new ScriptCompilationException("Unable to find DMN script engine");
    }
}

