/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.camunda.bpm.dmn.engine.DmnDecisionOutput;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.scriptengine.DmnScriptEngineFactory;
import org.camunda.bpm.engine.delegate.VariableScope;

public abstract class ExecutableScript {
    protected final String language;

    protected ExecutableScript(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public Object execute(ScriptEngine scriptEngine, VariableScope variableScope, Bindings bindings) {
        Object result = this.evaluate(scriptEngine, variableScope, bindings);
        return this.postProcessResult(result);
    }

    protected abstract Object evaluate(ScriptEngine var1, VariableScope var2, Bindings var3);

    public Object postProcessResult(Object result) {
        if (result != null && DmnScriptEngineFactory.names.contains(this.language)) {
            return this.postProcessDmnResult((DmnDecisionResult)result);
        }
        return result;
    }

    protected Object postProcessDmnResult(DmnDecisionResult result) {
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return this.unpackDecisionOutput((DmnDecisionOutput)result.get(0));
        }
        return this.unpackDecisionOutputs(result);
    }

    protected Object unpackDecisionOutput(DmnDecisionOutput output) {
        if (output.isEmpty()) {
            return Collections.emptyMap();
        }
        if (output.size() == 1) {
            return output.getValue();
        }
        return output;
    }

    protected Object unpackDecisionOutputs(DmnDecisionResult result) {
        int entriesCount = 0;
        for (DmnDecisionOutput output : result) {
            int size = output.size();
            if (size <= entriesCount) continue;
            entriesCount = size;
        }
        if (entriesCount == 0) {
            ArrayList<Object> nullList = new ArrayList<Object>();
            for (DmnDecisionOutput output : result) {
                nullList.add(null);
            }
            return nullList;
        }
        if (entriesCount == 1) {
            return this.createDecisionOutputList((List<DmnDecisionOutput>)result);
        }
        return result;
    }

    protected List<Object> createDecisionOutputList(List<DmnDecisionOutput> result) {
        ArrayList<Object> outputList = new ArrayList<Object>();
        for (DmnDecisionOutput output : result) {
            outputList.add(output.getValue());
        }
        return outputList;
    }
}

