/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import junit.framework.AssertionFailedError;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.LogUtil;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public abstract class AbstractProcessEngineTestCase
extends PvmTestCase {
    protected ProcessEngine processEngine;
    protected LogUtil.ThreadLogMode threadRenderingMode = DEFAULT_THREAD_LOG_MODE;
    protected String deploymentId;
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected FilterService filterService;

    protected abstract void initializeProcessEngine();

    protected void closeDownProcessEngine() {
    }

    public void runBare() throws Throwable {
        this.initializeProcessEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        log.severe("                                                                                           ");
        try {
            this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
        }
        catch (AssertionFailedError e) {
            log.severe("                                                                                           ");
            log.log(Level.SEVERE, "ASSERTION FAILED: " + (Object)((Object)e), e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            log.severe("                                                                                           ");
            log.log(Level.SEVERE, "EXCEPTION: " + e, e);
            this.exception = e;
            throw e;
        }
        finally {
            TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, ((Object)((Object)this)).getClass(), this.getName());
            this.identityService.clearAuthentication();
            TestHelper.assertAndEnsureCleanDbAndCache(this.processEngine);
            ClockUtil.reset();
            this.closeDownProcessEngine();
            this.clearServiceReferences();
        }
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.formService = this.processEngine.getFormService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
        this.filterService = this.processEngine.getFilterService();
    }

    protected void clearServiceReferences() {
        this.processEngineConfiguration = null;
        this.repositoryService = null;
        this.runtimeService = null;
        this.taskService = null;
        this.formService = null;
        this.historyService = null;
        this.identityService = null;
        this.managementService = null;
        this.authorizationService = null;
        this.caseService = null;
        this.filterService = null;
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
    }

    public void assertProcessNotEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new AssertionFailedError("Expected process instance '" + processInstanceId + "' to be still active but it was not in the db");
        }
    }

    public void assertCaseEnded(String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.processEngine.getCaseService().createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance != null) {
            throw new AssertionFailedError("Expected finished case instance '" + caseInstanceId + "' but it was still in the db");
        }
    }

    @Deprecated
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        this.waitForJobExecutorToProcessAllJobs(maxMillisToWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait) {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        long intervalMillis = 1000L;
        int jobExecutorWaitTime = jobExecutor.getWaitTimeInMillis() * 2;
        if (maxMillisToWait < (long)jobExecutorWaitTime) {
            maxMillisToWait = jobExecutorWaitTime;
        }
        try {
            Timer timer = new Timer();
            InterruptTask task = new InterruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    try {
                        areJobsAvailable = this.areJobsAvailable();
                    }
                    catch (Throwable t) {}
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    @Deprecated
    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        this.waitForJobExecutorOnCondition(maxMillisToWait, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorOnCondition(long maxMillisToWait, Callable<Boolean> condition) {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        long intervalMillis = 500L;
        if (maxMillisToWait < (long)(jobExecutor.getWaitTimeInMillis() * 2)) {
            maxMillisToWait = jobExecutor.getWaitTimeInMillis() * 2;
        }
        try {
            Timer timer = new Timer();
            InterruptTask task = new InterruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean conditionIsViolated = true;
            try {
                while (conditionIsViolated && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    conditionIsViolated = condition.call() == false;
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while waiting on condition: " + e.getMessage(), e);
            }
            finally {
                timer.cancel();
            }
            if (conditionIsViolated) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    public void executeAvailableJobs() {
        this.executeAvailableJobs(0, Integer.MAX_VALUE, true);
    }

    public void executeAvailableJobs(int expectedExecutions) {
        this.executeAvailableJobs(0, expectedExecutions, false);
    }

    private void executeAvailableJobs(int jobsExecuted, int expectedExecutions, boolean ignoreLessExecutions) {
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        if (jobs.isEmpty()) {
            AbstractProcessEngineTestCase.assertTrue((String)("executed less jobs than expected. expected <" + expectedExecutions + "> actual <" + jobsExecuted + ">"), (jobsExecuted == expectedExecutions || ignoreLessExecutions ? 1 : 0) != 0);
            return;
        }
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
                ++jobsExecuted;
            }
            catch (Exception e) {}
        }
        AbstractProcessEngineTestCase.assertTrue((String)("executed more jobs than expected. expected <" + expectedExecutions + "> actual <" + jobsExecuted + ">"), (jobsExecuted <= expectedExecutions ? 1 : 0) != 0);
        this.executeAvailableJobs(jobsExecuted, expectedExecutions, ignoreLessExecutions);
    }

    public boolean areJobsAvailable() {
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            if (job.isSuspended() || job.getRetries() <= 0 || job.getDuedate() != null && !ClockUtil.getCurrentTime().after(job.getDuedate())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected List<ActivityInstance> getInstancesForActivitiyId(ActivityInstance activityInstance, String activityId) {
        return this.getInstancesForActivityId(activityInstance, activityId);
    }

    protected List<ActivityInstance> getInstancesForActivityId(ActivityInstance activityInstance, String activityId) {
        ArrayList<ActivityInstance> result = new ArrayList<ActivityInstance>();
        if (activityInstance.getActivityId().equals(activityId)) {
            result.add(activityInstance);
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            result.addAll(this.getInstancesForActivityId(childInstance, activityId));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsUser(String userId, List<String> groupIds, Runnable r) {
        try {
            this.identityService.setAuthenticatedUserId(userId);
            this.processEngineConfiguration.setAuthorizationEnabled(true);
            r.run();
        }
        finally {
            this.identityService.setAuthenticatedUserId(null);
            this.processEngineConfiguration.setAuthorizationEnabled(false);
        }
    }

    public void deployment(BpmnModelInstance ... bpmnModelInstances) {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        for (int i = 0; i < bpmnModelInstances.length; ++i) {
            BpmnModelInstance bpmnModelInstance = bpmnModelInstances[i];
            deploymentBuilder.addModelInstance("testProcess-" + i + ".bpmn", bpmnModelInstance);
        }
        this.deploymentId = deploymentBuilder.deploy().getId();
    }

    private static class InterruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InterruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }

    @Deprecated
    private static class InteruptTask
    extends InterruptTask {
        public InteruptTask(Thread thread) {
            super(thread);
        }
    }
}

