/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.tree;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;

public class ActivityAwareScopeExecutionCollector
implements TreeVisitor<PvmExecutionImpl> {
    protected ScopeImpl commonChildScope;
    protected ScopeImpl currentActivity;
    protected List<PvmExecutionImpl> executions = new ArrayList<PvmExecutionImpl>();

    public ActivityAwareScopeExecutionCollector(ScopeImpl commonChildScope) {
        this.commonChildScope = commonChildScope;
        this.currentActivity = commonChildScope;
    }

    @Override
    public void visit(PvmExecutionImpl obj) {
        if (obj.getActivity() != null) {
            this.currentActivity = obj.getActivity();
        }
        if (obj.isScope()) {
            if (!this.currentActivity.isScope() || obj.getActivityInstanceId() == null) {
                this.currentActivity = this.getFlowScope(this.currentActivity);
            }
            if (this.isAncestorOf(this.currentActivity, this.commonChildScope)) {
                this.executions.add(obj);
            }
            this.currentActivity = this.getFlowScope(this.currentActivity);
        }
    }

    public List<PvmExecutionImpl> getExecutions() {
        return this.executions;
    }

    protected boolean isAncestorOf(ScopeImpl ancestorScope, ScopeImpl candidateDescendantScope) {
        if (candidateDescendantScope == ancestorScope) {
            return true;
        }
        if (candidateDescendantScope.getFlowScope() != null) {
            return this.isAncestorOf(ancestorScope, candidateDescendantScope.getFlowScope());
        }
        return false;
    }

    protected ScopeImpl getFlowScope(ScopeImpl scope) {
        if (scope != scope.getProcessDefinition()) {
            return scope.getFlowScope();
        }
        return scope;
    }
}

