/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.type.ValueTypeResolver;

public class ValueTypeResolverImpl
implements ValueTypeResolver {
    protected Map<String, ValueType> knownTypes = new HashMap<String, ValueType>();

    public ValueTypeResolverImpl() {
        this.addType(ValueType.BOOLEAN);
        this.addType(ValueType.BYTES);
        this.addType(ValueType.DATE);
        this.addType(ValueType.DOUBLE);
        this.addType(ValueType.INTEGER);
        this.addType(ValueType.LONG);
        this.addType(ValueType.NULL);
        this.addType(ValueType.SHORT);
        this.addType(ValueType.STRING);
        this.addType(ValueType.OBJECT);
        this.addType(ValueType.NUMBER);
        this.addType(ValueType.FILE);
    }

    @Override
    public void addType(ValueType type) {
        this.knownTypes.put(type.getName(), type);
    }

    @Override
    public ValueType typeForName(String typeName) {
        return this.knownTypes.get(typeName);
    }

    @Override
    public Collection<ValueType> getSubTypes(ValueType type) {
        ArrayList<ValueType> types = new ArrayList<ValueType>();
        HashSet<ValueType> validParents = new HashSet<ValueType>();
        validParents.add(type);
        for (ValueType knownType : this.knownTypes.values()) {
            if (!validParents.contains(knownType.getParent())) continue;
            validParents.add(knownType);
            if (knownType.isAbstract()) continue;
            types.add(knownType);
        }
        return types;
    }
}

