/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import java.io.InputStream;
import org.camunda.bpm.engine.impl.core.variable.value.UntypedValueImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.BytesValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class ByteArrayValueSerializer
extends PrimitiveValueSerializer<BytesValue> {
    public ByteArrayValueSerializer() {
        super(ValueType.BYTES);
    }

    @Override
    public BytesValue convertToTypedValue(UntypedValueImpl untypedValue) {
        Object value = untypedValue.getValue();
        if (value instanceof byte[]) {
            return Variables.byteArrayValue((byte[])value);
        }
        byte[] data = IoUtil.readInputStream((InputStream)value, null);
        return Variables.byteArrayValue(data);
    }

    @Override
    public BytesValue readValue(ValueFields valueFields) {
        return Variables.byteArrayValue(ByteArrayValueSerializer.getBytes(valueFields));
    }

    @Override
    public void writeValue(BytesValue variableValue, ValueFields valueFields) {
        ByteArrayValueSerializer.setBytes(valueFields, (byte[])variableValue.getValue());
    }

    @Override
    protected boolean canWriteValue(TypedValue typedValue) {
        return super.canWriteValue(typedValue) || typedValue.getValue() instanceof InputStream;
    }

    public static byte[] getBytes(ValueFields valueFields) {
        byte[] byteArray = null;
        if (valueFields.getByteArrayValue() != null) {
            byteArray = valueFields.getByteArrayValue().getBytes();
        }
        return byteArray;
    }

    public static void setBytes(ValueFields valueFields, byte[] bytes) {
        ByteArrayEntity byteArray = valueFields.getByteArrayValue();
        if (byteArray == null) {
            valueFields.setByteArrayValue(bytes);
        } else {
            byteArray.setBytes(bytes);
        }
    }
}

