/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test;

import java.io.FileNotFoundException;
import java.util.Date;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ProcessEngineRule
extends TestWatcher
implements ProcessEngineServices {
    protected String configurationResource = "camunda.cfg.xml";
    protected String configurationResourceCompat = "activiti.cfg.xml";
    protected String deploymentId = null;
    protected boolean ensureCleanAfterTest = false;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    protected FilterService filterService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;

    public ProcessEngineRule() {
        this(false);
    }

    public ProcessEngineRule(boolean ensureCleanAfterTest) {
        this.ensureCleanAfterTest = ensureCleanAfterTest;
    }

    public ProcessEngineRule(String configurationResource) {
        this(configurationResource, false);
    }

    public ProcessEngineRule(String configurationResource, boolean ensureCleanAfterTest) {
        this.configurationResource = configurationResource;
        this.ensureCleanAfterTest = ensureCleanAfterTest;
    }

    public ProcessEngineRule(ProcessEngine processEngine) {
        this(processEngine, false);
    }

    public ProcessEngineRule(ProcessEngine processEngine, boolean ensureCleanAfterTest) {
        this.processEngine = processEngine;
        this.ensureCleanAfterTest = ensureCleanAfterTest;
    }

    public void starting(Description description) {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        this.initializeServices();
        this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, description.getTestClass(), description.getMethodName(), (Deployment)description.getAnnotation(Deployment.class));
    }

    protected void initializeProcessEngine() {
        try {
            this.processEngine = TestHelper.getProcessEngine(this.configurationResource);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) {
                this.processEngine = TestHelper.getProcessEngine(this.configurationResourceCompat);
            }
            throw ex;
        }
    }

    protected void initializeServices() {
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
        this.filterService = this.processEngine.getFilterService();
    }

    protected void clearServiceReferences() {
        this.repositoryService = null;
        this.runtimeService = null;
        this.taskService = null;
        this.formService = null;
        this.historyService = null;
        this.identityService = null;
        this.managementService = null;
        this.authorizationService = null;
        this.caseService = null;
        this.filterService = null;
    }

    public void finished(Description description) {
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, description.getTestClass(), description.getMethodName());
        if (this.ensureCleanAfterTest) {
            TestHelper.assertAndEnsureCleanDbAndCache(this.processEngine);
        }
        ClockUtil.reset();
        this.clearServiceReferences();
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    @Override
    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    public void setHistoricDataService(HistoryService historicService) {
        this.setHistoryService(historicService);
    }

    @Override
    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Override
    public CaseService getCaseService() {
        return this.caseService;
    }

    public void setCaseService(CaseService caseService) {
        this.caseService = caseService;
    }

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    public void setFormService(FormService formService) {
        this.formService = formService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }

    @Override
    public FilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(FilterService filterService) {
        this.filterService = filterService;
    }
}

