/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.deployment;

import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationExecutionException;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;

public class RedeploymentProcessApplicationTest
extends PluggableProcessEngineTestCase {
    protected static final String DEPLOYMENT_NAME = "my-deployment";
    protected static final String PROCESS_KEY_1 = "process-1";
    protected static final String PROCESS_KEY_2 = "process-2";
    protected static final String BPMN_RESOURCE_1 = "path/to/my/process1.bpmn";
    protected static final String BPMN_RESOURCE_2 = "path/to/my/process2.bpmn";
    protected static final String CASE_KEY_1 = "oneTaskCase";
    protected static final String CASE_KEY_2 = "twoTaskCase";
    protected static final String CMMN_RESOURCE_1 = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String CMMN_RESOURCE_2 = "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn";

    public void testProcessOnePreviousDeploymentWithPA() {
        MyEmbeddedProcessApplication application = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_1), 2);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessTwoPreviousDeploymentWithPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_1), 3);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_1);
        RedeploymentProcessApplicationTest.assertFalse((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertTrue((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testProcessTwoPreviousDeploymentFirstDeploymentWithPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_1), 3);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testProcessTwoPreviousDeploymentDeleteSecondDeployment() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_1), 3);
        this.deleteDeployments(new Deployment[]{deployment2});
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertFalse((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment3});
    }

    public void testProcessTwoPreviousDeploymentUnregisterSecondPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_1), 3);
        this.managementService.unregisterProcessApplication(deployment2.getId(), true);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertFalse((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testProcessTwoDifferentPreviousDeploymentsWithDifferentPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name("my-deployment-1").addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name("my-deployment-2").addModelInstance(BPMN_RESOURCE_2, this.createProcessWithServiceTask(PROCESS_KEY_2)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_1), 2);
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_2), 2);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertFalse((boolean)application2.isCalled());
        application1.setCalled(false);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_2);
        RedeploymentProcessApplicationTest.assertFalse((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertTrue((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testProcessTwoPreviousDeploymentsWithDifferentPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).addModelInstance(BPMN_RESOURCE_2, this.createProcessWithServiceTask(PROCESS_KEY_2)).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_1), 3);
        this.verifyQueryResults((Query<?, ?>)this.processDefinitionQueryByKey(PROCESS_KEY_2), 2);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_1);
        RedeploymentProcessApplicationTest.assertFalse((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertTrue((boolean)application2.isCalled());
        application2.setCalled(false);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY_2);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertFalse((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseOnePreviousDeploymentWithPA() {
        MyEmbeddedProcessApplication application = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_1), 2);
        this.caseService.createCaseInstanceByKey(CASE_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testCaseTwoPreviousDeploymentWithPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_1), 3);
        this.caseService.createCaseInstanceByKey(CASE_KEY_1);
        RedeploymentProcessApplicationTest.assertFalse((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertTrue((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseTwoPreviousDeploymentFirstDeploymentWithPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_1), 3);
        this.caseService.createCaseInstanceByKey(CASE_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseTwoPreviousDeploymentDeleteSecondDeployment() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_1), 3);
        this.deleteDeployments(new Deployment[]{deployment2});
        this.caseService.createCaseInstanceByKey(CASE_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertFalse((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment3});
    }

    public void testCaseTwoPreviousDeploymentUnregisterSecondPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_1), 3);
        this.managementService.unregisterProcessApplication(deployment2.getId(), true);
        this.caseService.createCaseInstanceByKey(CASE_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertFalse((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseTwoDifferentPreviousDeploymentsWithDifferentPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name("my-deployment-1").addClasspathResource(CMMN_RESOURCE_1).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name("my-deployment-2").addClasspathResource(CMMN_RESOURCE_2).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_1), 2);
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_2), 2);
        this.caseService.createCaseInstanceByKey(CASE_KEY_1);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertFalse((boolean)application2.isCalled());
        application1.setCalled(false);
        this.caseService.createCaseInstanceByKey(CASE_KEY_2);
        RedeploymentProcessApplicationTest.assertFalse((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertTrue((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseTwoPreviousDeploymentsWithDifferentPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).addClasspathResource(CMMN_RESOURCE_2).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_1), 3);
        this.verifyQueryResults((Query<?, ?>)this.caseDefinitionQueryByKey(CASE_KEY_2), 2);
        this.caseService.createCaseInstanceByKey(CASE_KEY_1);
        RedeploymentProcessApplicationTest.assertFalse((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertTrue((boolean)application2.isCalled());
        application2.setCalled(false);
        this.caseService.createCaseInstanceByKey(CASE_KEY_2);
        RedeploymentProcessApplicationTest.assertTrue((boolean)application1.isCalled());
        RedeploymentProcessApplicationTest.assertFalse((boolean)application2.isCalled());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    protected void verifyQueryResults(Query<?, ?> query, int countExpected) {
        RedeploymentProcessApplicationTest.assertEquals((long)countExpected, (long)query.count());
    }

    protected ProcessDefinitionQuery processDefinitionQueryByKey(String key) {
        return this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
    }

    protected CaseDefinitionQuery caseDefinitionQueryByKey(String key) {
        return this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key);
    }

    protected void deleteDeployments(Deployment ... deployments) {
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    protected BpmnModelInstance createProcessWithServiceTask(String key) {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().serviceTask().camundaExpression("${true}")).endEvent().done();
    }

    public class MyEmbeddedProcessApplication
    extends EmbeddedProcessApplication {
        protected ProcessApplicationReference reference;
        protected boolean called;

        public ProcessApplicationReference getReference() {
            if (this.reference == null) {
                this.reference = super.getReference();
            }
            return this.reference;
        }

        public <T> T execute(Callable<T> callable) throws ProcessApplicationExecutionException {
            this.called = true;
            return (T)super.execute(callable);
        }

        public boolean isCalled() {
            return this.called;
        }

        public void setCalled(boolean called) {
            this.called = called;
        }
    }
}

