/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.deployment;

import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.impl.application.ProcessApplicationManager;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;

public class RedeploymentRegistrationTest
extends PluggableProcessEngineTestCase {
    protected static final String DEPLOYMENT_NAME = "my-deployment";
    protected static final String PROCESS_KEY_1 = "process-1";
    protected static final String PROCESS_KEY_2 = "process-2";
    protected static final String BPMN_RESOURCE_1 = "path/to/my/process1.bpmn";
    protected static final String BPMN_RESOURCE_2 = "path/to/my/process2.bpmn";
    protected static final String CASE_KEY_1 = "oneTaskCase";
    protected static final String CASE_KEY_2 = "twoTaskCase";
    protected static final String CMMN_RESOURCE_1 = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String CMMN_RESOURCE_2 = "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn";
    protected static final String DECISION_KEY_1 = "decision";
    protected static final String DECISION_KEY_2 = "anotherDecision";
    protected static final String DMN_RESOURCE_1 = "org/camunda/bpm/engine/test/api/dmn/Example.dmn";
    protected static final String DMN_RESOURCE_2 = "org/camunda/bpm/engine/test/api/dmn/Another_Example.dmn";
    protected EmbeddedProcessApplication processApplication;

    protected void setUp() throws Exception {
        this.processApplication = new EmbeddedProcessApplication();
    }

    public void testProcessRegistrationNotFoundByDeploymentId() {
        ProcessApplicationReference reference = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference, (Object)this.getProcessApplicationForDeployment(deployment1.getId()));
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessRegistrationNotFoundByDefinition() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForProcessDefinition(definitionId));
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testProcessRegistrationFoundByDeploymentId() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDeployment(deployment1.getId()));
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessRegistrationFoundFromPreviousDefinition() {
        ProcessApplicationReference reference = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference, (Object)this.getProcessApplicationForProcessDefinition(definitionId));
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessRegistrationFoundFromLatestDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForProcessDefinition(definitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessRegistrationFoundOnlyForOneProcessDefinition() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).addModelInstance(BPMN_RESOURCE_2, this.createProcessWithServiceTask(PROCESS_KEY_2)).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        String secondDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForProcessDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForProcessDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testProcessRegistrationFoundFromDifferentDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).addModelInstance(BPMN_RESOURCE_2, this.createProcessWithServiceTask(PROCESS_KEY_2)).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        String secondDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForProcessDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForProcessDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testProcessRegistrationFoundFromSameDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).addModelInstance(BPMN_RESOURCE_2, this.createProcessWithServiceTask(PROCESS_KEY_2)).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_2, this.createProcessWithServiceTask(PROCESS_KEY_2)).deploy();
        Deployment deployment4 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        String secondDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForProcessDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForProcessDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3, deployment4});
    }

    public void testProcessRegistrationFoundFromDifferentDeployments() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name("my-deployment-1").addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name("my-deployment-2").addModelInstance(BPMN_RESOURCE_2, this.createProcessWithServiceTask(PROCESS_KEY_2)).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        String secondDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForProcessDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForProcessDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testProcessRegistrationNotFoundWhenDeletingDeployment() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForProcessDefinition(firstDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment2});
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForProcessDefinition(firstDefinitionId));
        this.deleteDeployments(deployment1, deployment3);
    }

    public void testProcessRegistrationFoundAfterDiscardingDeploymentCache() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE_1, this.createProcessWithServiceTask(PROCESS_KEY_1)).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestProcessDefinitionByKey(PROCESS_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForProcessDefinition(firstDefinitionId));
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForProcessDefinition(firstDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseRegistrationNotFoundByDeploymentId() {
        ProcessApplicationReference reference = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference, (Object)this.getProcessApplicationForDeployment(deployment1.getId()));
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testCaseRegistrationNotFoundByDefinition() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForCaseDefinition(definitionId));
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testCaseRegistrationFoundByDeploymentId() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDeployment(deployment1.getId()));
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testCaseRegistrationFoundFromPreviousDefinition() {
        ProcessApplicationReference reference = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference, (Object)this.getProcessApplicationForCaseDefinition(definitionId));
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testCaseRegistrationFoundFromLatestDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForCaseDefinition(definitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testCaseRegistrationFoundOnlyForOneCaseDefinition() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).addClasspathResource(CMMN_RESOURCE_2).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        String secondDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForCaseDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForCaseDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseRegistrationFoundFromDifferentDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).addClasspathResource(CMMN_RESOURCE_2).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        String secondDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForCaseDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForCaseDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseRegistrationFoundFromSameDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).addClasspathResource(CMMN_RESOURCE_2).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_2).deploy();
        Deployment deployment4 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        String secondDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForCaseDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForCaseDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3, deployment4});
    }

    public void testCaseRegistrationFoundFromDifferentDeployments() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name("my-deployment-1").addClasspathResource(CMMN_RESOURCE_1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name("my-deployment-2").addClasspathResource(CMMN_RESOURCE_2).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        String secondDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForCaseDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForCaseDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testCaseRegistrationNotFoundWhenDeletingDeployment() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForCaseDefinition(firstDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment2});
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForCaseDefinition(firstDefinitionId));
        this.deleteDeployments(deployment1, deployment3);
    }

    public void testCaseRegistrationFoundAfterDiscardingDeploymentCache() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(CMMN_RESOURCE_1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestCaseDefinitionByKey(CASE_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForCaseDefinition(firstDefinitionId));
        this.processEngineConfiguration.getDeploymentCache().discardCaseDefinitionCache();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForCaseDefinition(firstDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testDecisionRegistrationNotFoundByDeploymentId() {
        ProcessApplicationReference reference = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference).name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference, (Object)this.getProcessApplicationForDeployment(deployment1.getId()));
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testDecisionRegistrationNotFoundByDefinition() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDecisionDefinition(definitionId));
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testDecisionRegistrationFoundByDeploymentId() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDeployment(deployment1.getId()));
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testDecisionRegistrationFoundFromPreviousDefinition() {
        ProcessApplicationReference reference = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference).name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference, (Object)this.getProcessApplicationForDecisionDefinition(definitionId));
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testDecisionRegistrationFoundFromLatestDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String definitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDecisionDefinition(definitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDeployment(deployment2.getId()));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testDecisionRegistrationFoundOnlyForOneProcessDefinition() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).addClasspathResource(DMN_RESOURCE_2).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        String secondDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDecisionDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDecisionDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testDecisionRegistrationFoundFromDifferentDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).addClasspathResource(DMN_RESOURCE_2).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        String secondDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDecisionDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDecisionDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testDecisionRegistrationFoundFromSameDeployment() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).addClasspathResource(DMN_RESOURCE_2).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_2).deploy();
        Deployment deployment4 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        String secondDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDecisionDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDecisionDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3, deployment4});
    }

    public void testDecisionRegistrationFoundFromDifferentDeployments() {
        ProcessApplicationReference reference1 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(reference1).name("my-deployment-1").addClasspathResource(DMN_RESOURCE_1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name("my-deployment-2").addClasspathResource(DMN_RESOURCE_2).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        String secondDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_2).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference1, (Object)this.getProcessApplicationForDecisionDefinition(firstDefinitionId));
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDecisionDefinition(secondDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testDecisionRegistrationNotFoundWhenDeletingDeployment() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDecisionDefinition(firstDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment2});
        RedeploymentRegistrationTest.assertNull((Object)this.getProcessApplicationForDecisionDefinition(firstDefinitionId));
        this.deleteDeployments(deployment1, deployment3);
    }

    public void testDecisionRegistrationFoundAfterDiscardingDeploymentCache() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(DMN_RESOURCE_1).deploy();
        ProcessApplicationReference reference2 = this.processApplication.getReference();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(reference2).name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Deployment deployment3 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        String firstDefinitionId = this.queryLatestDecisionDefinitionByKey(DECISION_KEY_1).getId();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDecisionDefinition(firstDefinitionId));
        this.processEngineConfiguration.getDeploymentCache().discardDecisionDefinitionCache();
        RedeploymentRegistrationTest.assertEquals((Object)reference2, (Object)this.getProcessApplicationForDecisionDefinition(firstDefinitionId));
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    protected ProcessDefinition queryLatestProcessDefinitionByKey(String key) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).latestVersion().singleResult();
    }

    protected ProcessApplicationReference getProcessApplicationForProcessDefinition(final String processDefinitionId) {
        return this.executeCommand(new Command<ProcessApplicationReference>(){

            public ProcessApplicationReference execute(CommandContext commandContext) {
                ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
                DeploymentCache deploymentCache = configuration.getDeploymentCache();
                ProcessDefinitionEntity definition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
                return ProcessApplicationContextUtil.getTargetProcessApplication((ResourceDefinitionEntity)definition);
            }
        });
    }

    protected CaseDefinition queryLatestCaseDefinitionByKey(String key) {
        return (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).latestVersion().singleResult();
    }

    protected ProcessApplicationReference getProcessApplicationForCaseDefinition(final String caseDefinitionId) {
        return this.executeCommand(new Command<ProcessApplicationReference>(){

            public ProcessApplicationReference execute(CommandContext commandContext) {
                ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
                DeploymentCache deploymentCache = configuration.getDeploymentCache();
                CaseDefinitionEntity definition = deploymentCache.findDeployedCaseDefinitionById(caseDefinitionId);
                return ProcessApplicationContextUtil.getTargetProcessApplication((ResourceDefinitionEntity)definition);
            }
        });
    }

    protected DecisionDefinition queryLatestDecisionDefinitionByKey(String key) {
        return (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(key).latestVersion().singleResult();
    }

    protected ProcessApplicationReference getProcessApplicationForDecisionDefinition(final String decisionDefinitionId) {
        return this.executeCommand(new Command<ProcessApplicationReference>(){

            public ProcessApplicationReference execute(CommandContext commandContext) {
                ProcessEngineConfigurationImpl configuration = commandContext.getProcessEngineConfiguration();
                DeploymentCache deploymentCache = configuration.getDeploymentCache();
                DecisionDefinitionEntity definition = deploymentCache.findDeployedDecisionDefinitionById(decisionDefinitionId);
                return ProcessApplicationContextUtil.getTargetProcessApplication((ResourceDefinitionEntity)definition);
            }
        });
    }

    protected ProcessApplicationReference getProcessApplicationForDeployment(String deploymentId) {
        return this.getProcessApplicationManager().getProcessApplicationForDeployment(deploymentId);
    }

    protected ProcessApplicationManager getProcessApplicationManager() {
        return this.processEngineConfiguration.getProcessApplicationManager();
    }

    protected ProcessApplicationReference executeCommand(Command<ProcessApplicationReference> command) {
        return (ProcessApplicationReference)this.processEngineConfiguration.getCommandExecutorTxRequired().execute(command);
    }

    protected void deleteDeployments(Deployment ... deployments) {
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    protected BpmnModelInstance createProcessWithServiceTask(String key) {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().serviceTask().camundaExpression("${true}")).endEvent().done();
    }
}

