/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Date;
import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.Deployment;

public class ActivateJobDefinitionTest
extends PluggableProcessEngineTestCase {
    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-job-definition");
                return null;
            }
        });
    }

    public void testActivationById_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionById(null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testActivationByIdAndActivateJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionById(null, false);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionById(null, true);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testActivationByIdAndActivateJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionById(null, false, null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionById(null, true, null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionById(null, false, new Date());
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionById(null, true, new Date());
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationById_shouldRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByIdAndActivateJobsFlag_shouldRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByIdAndActivateJobsFlag_shouldSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationById_shouldExecuteImmediatelyAndRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationById_shouldExecuteImmediatelyAndSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationById_shouldExecuteDelayedAndRetainJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), false, new Date(oneWeekFromStartTime));
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        ActivateJobDefinitionTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationById_shouldExecuteDelayedAndSuspendJobs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), true, new Date(oneWeekFromStartTime));
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        ActivateJobDefinitionTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    public void testActivationByProcessDefinitionId_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testActivationByProcessDefinitionIdAndActivateJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, false);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, true);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testActivationByProcessDefinitionIdAndActivateJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, false, null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, true, null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, false, new Date());
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(null, true, new Date());
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionId_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionIdAndActivateJobsFlag_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionIdAndActivateJobsFlag_shouldSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionId_shouldExecuteImmediatelyAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionId_shouldExecuteImmediatelyAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionId_shouldExecuteDelayedAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), false, new Date(oneWeekFromStartTime));
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        ActivateJobDefinitionTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionId_shouldExecuteDelayedAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinition.getId(), true, new Date(oneWeekFromStartTime));
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        ActivateJobDefinitionTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    public void testActivationByProcessDefinitionKey_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testActivationByProcessDefinitionKeyAndActivateJobsFlag_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, false);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, true);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testActivationByProcessDefinitionKeyAndActivateJobsFlagAndExecutionDate_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, false, null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, true, null);
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, false, new Date());
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(null, true, new Date());
            ActivateJobDefinitionTest.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionKey_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey());
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionKeyAndActivateJobsFlag_shouldRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionKeyAndActivateJobsFlag_shouldSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionKey_shouldExecuteImmediatelyAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionKey_shouldExecuteImmediatelyAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionKey_shouldExecuteDelayedAndRetainJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), false, new Date(oneWeekFromStartTime));
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        ActivateJobDefinitionTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        Job suspendedJob = (Job)jobQuery.suspended().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertTrue((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionKey_shouldExecuteDelayedAndSuspendJobs() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.managementService.activateJobDefinitionByProcessDefinitionKey(processDefinition.getKey(), true, new Date(oneWeekFromStartTime));
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        ActivateJobDefinitionTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        JobDefinition activeJobDefinition = (JobDefinition)jobDefinitionQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJobDefinition.getId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJobDefinition.isSuspended());
        jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)1L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        ActivateJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        ActivateJobDefinitionTest.assertFalse((boolean)activeJob.isSuspended());
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKeyAndActivateJobsFlag_shouldRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, false);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKeyAndActivateJobsFlag_shouldSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, true);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndRetainJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, false, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteImmediatelyAndSuspendJobs() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, true, null);
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndRetainJobs() {
        String key = "suspensionProcess";
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, false, new Date(oneWeekFromStartTime));
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        ActivateJobDefinitionTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.suspended().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testMultipleSuspensionByProcessDefinitionKey_shouldExecuteDelayedAndSuspendJobs() {
        String key = "suspensionProcess";
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        this.managementService.activateJobDefinitionByProcessDefinitionKey(key, true, new Date(oneWeekFromStartTime));
        JobDefinitionQuery jobDefinitionQuery = this.managementService.createJobDefinitionQuery();
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.suspended().count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job delayedActivationJob = (Job)jobQuery.timers().active().singleResult();
        ActivateJobDefinitionTest.assertNotNull((Object)delayedActivationJob);
        this.managementService.executeJob(delayedActivationJob.getId());
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobDefinitionQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobDefinitionQuery.suspended().count());
        jobQuery = this.managementService.createJobQuery();
        ActivateJobDefinitionTest.assertEquals((long)3L, (long)jobQuery.active().count());
        ActivateJobDefinitionTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }
}

