/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProcessApplicationDeploymentTest
extends PluggableProcessEngineTestCase {
    private EmbeddedProcessApplication processApplication;

    protected void setUp() throws Exception {
        this.processApplication = new EmbeddedProcessApplication();
    }

    public void testEmptyDeployment() {
        try {
            this.repositoryService.createDeployment(this.processApplication.getReference()).deploy();
            ProcessApplicationDeploymentTest.fail((String)"it should not be possible to deploy without deployment resources");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().deploy();
            ProcessApplicationDeploymentTest.fail((String)"it should not be possible to deploy without deployment resources");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testSimpleProcessApplicationDeployment() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationRegistration registration = deployment.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment});
    }

    public void testProcessApplicationDeploymentNoChanges() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationRegistration registration = deployment.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment});
    }

    public void testPartialChangesDeployAll() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).deploy();
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)4L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        List processDefinitionsModel1 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)processDefinitionsModel1.size());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitionsModel1.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitionsModel1.get(1)).getVersion());
        List processDefinitionsModel2 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)processDefinitionsModel2.size());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitionsModel2.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitionsModel2.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testPartialChangesDeployChangedOnly() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).deploy();
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinition processDefinitionModel1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
        ProcessApplicationDeploymentTest.assertNotNull((Object)processDefinitionModel1);
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinitionModel1.getVersion());
        ProcessApplicationDeploymentTest.assertEquals((String)deployment1.getId(), (String)processDefinitionModel1.getDeploymentId());
        List processDefinitionsModel2 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)processDefinitionsModel2.size());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitionsModel2.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitionsModel2.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        BpmnModelInstance anotherChangedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
        ProcessApplicationDeployment deployment3 = this.repositoryService.createDeployment(this.processApplication.getReference()).enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", anotherChangedModel2).name("deployment").deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count());
        ProcessApplicationDeploymentTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count());
        registration = deployment3.getProcessApplicationRegistration();
        deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)3, (int)deploymentIds.size());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2, deployment3});
    }

    public void testPartialChangesResumePreviousVersion() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).deploy();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).deploy();
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)registration.getDeploymentIds().size());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessApplicationDeploymentResumePreviousVersions() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version2.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsDifferentKeys() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").resumePreviousVersions().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)deployment2.getId(), (String)((String)deploymentIds.iterator().next()));
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessApplicationDeploymentNoResume() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).addClasspathResource("org/camunda/bpm/engine/test/api/repository/version2.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentName() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version2.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentNameDeployDifferentProcesses() {
        BpmnModelInstance process1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance process2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn", process1).deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process2.bpmn", process2).deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment, deployment2});
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentNameNoResume() {
        BpmnModelInstance process1 = Bpmn.createExecutableProcess((String)"process1").done();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn", process1).deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("anotherDeployment").resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process2.bpmn", process1).deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)deployment2.getId(), (String)((String)deploymentIds.iterator().next()));
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(new Deployment[]{deployment, deployment2});
    }

    public void testPartialChangesResumePreviousVersionByDeploymentName() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).deploy();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).deploy();
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)registration.getDeploymentIds().size());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testDeploymentSourceShouldBeNull() {
        String key = "process";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Deployment deployment1 = this.repositoryService.createDeployment().name("first-deployment-without-a-source").addModelInstance("process.bpmn", model).deploy();
        ProcessApplicationDeploymentTest.assertNull((Object)((Deployment)deploymentQuery.deploymentName("first-deployment-without-a-source").singleResult()).getSource());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("second-deployment-with-a-source").source(null).addModelInstance("process.bpmn", model).deploy();
        ProcessApplicationDeploymentTest.assertNull((Object)((Deployment)deploymentQuery.deploymentName("second-deployment-with-a-source").singleResult()).getSource());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testDeploymentSourceShouldNotBeNull() {
        String key = "process";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Deployment deployment1 = this.repositoryService.createDeployment().name("first-deployment-without-a-source").source("my-first-deployment-source").addModelInstance("process.bpmn", model).deploy();
        ProcessApplicationDeploymentTest.assertEquals((String)"my-first-deployment-source", (String)((Deployment)deploymentQuery.deploymentName("first-deployment-without-a-source").singleResult()).getSource());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("second-deployment-with-a-source").source("my-second-deployment-source").addModelInstance("process.bpmn", model).deploy();
        ProcessApplicationDeploymentTest.assertEquals((String)"my-second-deployment-source", (String)((Deployment)deploymentQuery.deploymentName("second-deployment-with-a-source").singleResult()).getSource());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testDefaultDeploymentSource() {
        String key = "process";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("first-deployment-with-a-source").addModelInstance("process.bpmn", model).deploy();
        ProcessApplicationDeploymentTest.assertEquals((String)"process application", (String)((Deployment)deploymentQuery.deploymentName("first-deployment-with-a-source").singleResult()).getSource());
        this.deleteDeployments(new Deployment[]{deployment});
    }

    public void testOverwriteDeploymentSource() {
        String key = "process";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("first-deployment-with-a-source").source("my-source").addModelInstance("process.bpmn", model).deploy();
        ProcessApplicationDeploymentTest.assertEquals((String)"my-source", (String)((Deployment)deploymentQuery.deploymentName("first-deployment-with-a-source").singleResult()).getSource());
        this.deleteDeployments(new Deployment[]{deployment});
    }

    public void testNullDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testNullAndProcessApplicationDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessApplicationAndNullDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testProcessApplicationDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testSameDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("cockpit").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("my-deployment").source("cockpit").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testDifferentDeploymentSourceShouldDeployNewVersion() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("my-source1").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("my-source2").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)2L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)2L, (long)deploymentQuery.count());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testNullAndNotNullDeploymentSourceShouldDeployNewVersion() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("my-source2").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)2L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)2L, (long)deploymentQuery.count());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    public void testNotNullAndNullDeploymentSourceShouldDeployNewVersion() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)key).done();
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("my-source1").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)2L, (long)processDefinitionQuery.count());
        ProcessApplicationDeploymentTest.assertEquals((long)2L, (long)deploymentQuery.count());
        this.deleteDeployments(new Deployment[]{deployment1, deployment2});
    }

    private void deleteDeployments(Deployment ... deployments) {
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    private void assertThatOneProcessIsDeployed() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertThat((Object)processDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinition.getVersion());
    }
}

