/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.examples.bpmn.tasklistener.RecorderTaskListener;
import org.camunda.bpm.engine.test.util.TestExecutionListener;

public class RepositoryServiceTest
extends PluggableProcessEngineTestCase {
    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-processdefinition");
                return null;
            }
        });
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartProcessInstanceById() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        RepositoryServiceTest.assertEquals((String)"oneTaskProcess", (String)processDefinition.getKey());
        RepositoryServiceTest.assertNotNull((Object)processDefinition.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testFindProcessDefinitionById() {
        List definitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)definitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(((ProcessDefinition)definitions.get(0)).getId()).singleResult();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertNotNull((Object)processDefinition);
        RepositoryServiceTest.assertEquals((String)"oneTaskProcess", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"The One Task Process", (String)processDefinition.getName());
        processDefinition = this.repositoryService.getProcessDefinition(((ProcessDefinition)definitions.get(0)).getId());
        RepositoryServiceTest.assertEquals((String)"This is a process for testing purposes", (String)processDefinition.getDescription());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteDeploymentWithRunningInstances() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        try {
            this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
            RepositoryServiceTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testDeleteDeploymentSkipCustomListeners() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteProcessInstanceSkipCustomListeners.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, false);
        RepositoryServiceTest.assertEquals((int)1, (int)TestExecutionListener.collectedEvents.size());
        TestExecutionListener.reset();
        deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, true);
        RepositoryServiceTest.assertTrue((boolean)TestExecutionListener.collectedEvents.isEmpty());
        TestExecutionListener.reset();
    }

    public void testDeleteDeploymentSkipCustomTaskListeners() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteProcessInstanceSkipCustomTaskListeners.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        RecorderTaskListener.getRecordedEvents().clear();
        this.repositoryService.deleteDeployment(deploymentId, true, false);
        RepositoryServiceTest.assertEquals((int)1, (int)RecorderTaskListener.getRecordedEvents().size());
        RecorderTaskListener.clear();
        deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, true);
        RepositoryServiceTest.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
        RecorderTaskListener.clear();
    }

    public void testDeleteDeploymentNullDeploymentId() {
        try {
            this.repositoryService.deleteDeployment(null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    public void testDeleteDeploymentCascadeNullDeploymentId() {
        try {
            this.repositoryService.deleteDeployment(null, true);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteDeploymentCascadeWithRunningInstances() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.repositoryService.deleteDeployment(processDefinition.getDeploymentId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/repository/one.cmmn"})
    public void testDeleteDeploymentClearsCache() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.repositoryService.getCmmnModelInstance(caseDefinitionId);
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        RepositoryServiceTest.assertTrue((boolean)deploymentCache.getProcessDefinitionCache().containsKey(processDefinitionId));
        RepositoryServiceTest.assertTrue((boolean)deploymentCache.getBpmnModelInstanceCache().containsKey(processDefinitionId));
        RepositoryServiceTest.assertTrue((boolean)deploymentCache.getCaseDefinitionCache().containsKey(caseDefinitionId));
        RepositoryServiceTest.assertTrue((boolean)deploymentCache.getCmmnModelInstanceCache().containsKey(caseDefinitionId));
        this.repositoryService.deleteDeployment(this.deploymentId, true);
        RepositoryServiceTest.assertFalse((boolean)deploymentCache.getProcessDefinitionCache().containsKey(processDefinitionId));
        RepositoryServiceTest.assertFalse((boolean)deploymentCache.getBpmnModelInstanceCache().containsKey(processDefinitionId));
        RepositoryServiceTest.assertFalse((boolean)deploymentCache.getCaseDefinitionCache().containsKey(caseDefinitionId));
        RepositoryServiceTest.assertFalse((boolean)deploymentCache.getCmmnModelInstanceCache().containsKey(caseDefinitionId));
    }

    public void testFindDeploymentResourceNamesNullDeploymentId() {
        try {
            this.repositoryService.getDeploymentResourceNames(null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    public void testFindDeploymentResourcesNullDeploymentId() {
        try {
            this.repositoryService.getDeploymentResources(null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("deploymentId is null", e.getMessage());
        }
    }

    public void testDeploymentWithDelayedProcessDefinitionActivation() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        Date inThreeDays = new Date(startTime.getTime() + 259200000L);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml").activateProcessDefinitionsOn(inThreeDays).deploy();
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            RepositoryServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        List jobs = this.managementService.createJobQuery().list();
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testDeploymentWithDelayedProcessDefinitionAndJobDefinitionActivation() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        Date inThreeDays = new Date(startTime.getTime() + 259200000L);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneAsyncTask.bpmn").activateProcessDefinitionsOn(inThreeDays).deploy();
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            RepositoryServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().active().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetResourceAsStreamUnexistingResourceInExistingDeployment() {
        org.camunda.bpm.engine.repository.Deployment deployment = (org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        try {
            this.repositoryService.getResourceAsStream(deployment.getId(), "org/camunda/bpm/engine/test/api/unexistingProcess.bpmn.xml");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no resource found with name", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetResourceAsStreamUnexistingDeployment() {
        try {
            this.repositoryService.getResourceAsStream("unexistingdeployment", "org/camunda/bpm/engine/test/api/unexistingProcess.bpmn.xml");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no resource found with name", ae.getMessage());
        }
    }

    public void testGetResourceAsStreamNullArguments() {
        try {
            this.repositoryService.getResourceAsStream(null, "resource");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
        try {
            this.repositoryService.getResourceAsStream("deployment", null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("resourceName is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.cmmn"})
    public void testGetCaseDefinition() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        String caseDefinitionId = caseDefinition.getId();
        CaseDefinition definition = this.repositoryService.getCaseDefinition(caseDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)definition);
        RepositoryServiceTest.assertEquals((String)caseDefinitionId, (String)definition.getId());
    }

    public void testGetCaseDefinitionByInvalidId() {
        try {
            this.repositoryService.getCaseDefinition("invalid");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("no deployed case definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getCaseDefinition(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("caseDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.cmmn"})
    public void testGetCaseModel() throws Exception {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        String caseDefinitionId = caseDefinition.getId();
        InputStream caseModel = this.repositoryService.getCaseModel(caseDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)caseModel);
        byte[] readInputStream = IoUtil.readInputStream((InputStream)caseModel, (String)"caseModel");
        String model = new String(readInputStream, "UTF-8");
        RepositoryServiceTest.assertTrue((boolean)model.contains("<case id=\"one\" name=\"One\">"));
        IoUtil.closeSilently((Closeable)caseModel);
    }

    public void testGetCaseModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getCaseModel("invalid");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("no deployed case definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getCaseModel(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("caseDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.dmn"})
    public void testGetDecisionDefinition() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        String decisionDefinitionId = decisionDefinition.getId();
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(decisionDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)definition);
        RepositoryServiceTest.assertEquals((String)decisionDefinitionId, (String)definition.getId());
    }

    public void testGetDecisionDefinitionByInvalidId() {
        try {
            this.repositoryService.getDecisionDefinition("invalid");
            RepositoryServiceTest.fail();
        }
        catch (NotFoundException e) {
            this.assertTextPresent("no deployed decision definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionDefinition(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("decisionDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.dmn"})
    public void testGetDecisionModel() throws Exception {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        String decisionDefinitionId = decisionDefinition.getId();
        InputStream decisionModel = this.repositoryService.getDecisionModel(decisionDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)decisionModel);
        byte[] readInputStream = IoUtil.readInputStream((InputStream)decisionModel, (String)"decisionModel");
        String model = new String(readInputStream, "UTF-8");
        RepositoryServiceTest.assertTrue((boolean)model.contains("<decision id=\"one\" name=\"One\">"));
        IoUtil.closeSilently((Closeable)decisionModel);
    }

    public void testGetDecisionModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getDecisionModel("invalid");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("no deployed decision definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionModel(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("decisionDefinitionId is null", e.getMessage());
        }
    }
}

