/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.NativeProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.DummySerializable;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;

public class ProcessInstanceQueryTest
extends PluggableProcessEngineTestCase {
    private static String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    private static String PROCESS_DEFINITION_KEY_2 = "oneTaskProcess2";
    private List<String> processInstanceIds;

    protected void setUp() throws Exception {
        super.setUp();
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess2.bpmn20.xml").deploy();
        this.processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.processInstanceIds.add(this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY, i + "").getId());
        }
        this.processInstanceIds.add(this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY_2, "1").getId());
    }

    protected void tearDown() throws Exception {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        super.tearDown();
    }

    public void testQueryNoSpecificsList() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertEquals((long)5L, (long)query.count());
        ProcessInstanceQueryTest.assertEquals((int)5, (int)query.list().size());
    }

    public void testQueryNoSpecificsSingleResult() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        try {
            query.singleResult();
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByProcessDefinitionKeySingleResult() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY_2);
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        ProcessInstanceQueryTest.assertEquals((int)1, (int)query.list().size());
        ProcessInstanceQueryTest.assertNotNull((Object)query.singleResult());
    }

    public void testQueryByInvalidProcessDefinitionKey() {
        ProcessInstanceQueryTest.assertNull((Object)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("invalid").singleResult());
        ProcessInstanceQueryTest.assertEquals((int)0, (int)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("invalid").list().size());
    }

    public void testQueryByProcessDefinitionKeyMultipleResults() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY);
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)query.count());
        ProcessInstanceQueryTest.assertEquals((int)4, (int)query.list().size());
        try {
            query.singleResult();
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByProcessInstanceId() {
        for (String processInstanceId : this.processInstanceIds) {
            ProcessInstanceQueryTest.assertNotNull((Object)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult());
            ProcessInstanceQueryTest.assertEquals((int)1, (int)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).list().size());
        }
    }

    public void testQueryByBusinessKeyAndProcessDefinitionKey() {
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("0", PROCESS_DEFINITION_KEY).count());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("1", PROCESS_DEFINITION_KEY).count());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("2", PROCESS_DEFINITION_KEY).count());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("3", PROCESS_DEFINITION_KEY).count());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("1", PROCESS_DEFINITION_KEY_2).count());
    }

    public void testQueryByBusinessKey() {
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("0").count());
        ProcessInstanceQueryTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("1").count());
    }

    public void testQueryByInvalidBusinessKey() {
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("invalid").count());
        try {
            this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(null).count();
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidProcessInstanceId() {
        ProcessInstanceQueryTest.assertNull((Object)this.runtimeService.createProcessInstanceQuery().processInstanceId("I do not exist").singleResult());
        ProcessInstanceQueryTest.assertEquals((int)0, (int)this.runtimeService.createProcessInstanceQuery().processInstanceId("I do not exist").list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryBySuperProcessInstanceId() {
        ProcessInstance superProcessInstance = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superProcessInstance.getId());
        ProcessInstance subProcessInstance = (ProcessInstance)query.singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)subProcessInstance);
        ProcessInstanceQueryTest.assertEquals((int)1, (int)query.list().size());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidSuperProcessInstanceId() {
        ProcessInstanceQueryTest.assertNull((Object)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId("invalid").singleResult());
        ProcessInstanceQueryTest.assertEquals((int)0, (int)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId("invalid").list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryBySubProcessInstanceId() {
        ProcessInstance superProcessInstance = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest");
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superProcessInstance.getId()).singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)subProcessInstance);
        ProcessInstanceQueryTest.assertEquals((String)superProcessInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
    }

    public void testQueryByInvalidSubProcessInstanceId() {
        ProcessInstanceQueryTest.assertNull((Object)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId("invalid").singleResult());
        ProcessInstanceQueryTest.assertEquals((int)0, (int)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId("invalid").list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryBySuperProcessInstanceIdNested() {
        ProcessInstance superProcessInstance = this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superProcessInstance.getId()).singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)subProcessInstance);
        ProcessInstance nestedSubProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(subProcessInstance.getId()).singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)nestedSubProcessInstance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryBySubProcessInstanceIdNested() {
        ProcessInstance superProcessInstance = this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superProcessInstance.getId()).singleResult();
        ProcessInstanceQueryTest.assertEquals((String)superProcessInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
        ProcessInstance nestedSubProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(subProcessInstance.getId()).singleResult();
        ProcessInstanceQueryTest.assertEquals((String)subProcessInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(nestedSubProcessInstance.getId()).singleResult()).getId());
    }

    public void testQueryPaging() {
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).count());
        ProcessInstanceQueryTest.assertEquals((int)2, (int)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).listPage(0, 2).size());
        ProcessInstanceQueryTest.assertEquals((int)3, (int)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).listPage(1, 3).size());
    }

    public void testQuerySorting() {
        ProcessInstanceQueryTest.assertEquals((int)5, (int)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        ProcessInstanceQueryTest.assertEquals((int)5, (int)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionId().asc()).list().size());
        ProcessInstanceQueryTest.assertEquals((int)5, (int)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionKey().asc()).list().size());
        ProcessInstanceQueryTest.assertEquals((int)5, (int)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessInstanceId().desc()).list().size());
        ProcessInstanceQueryTest.assertEquals((int)5, (int)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionId().desc()).list().size());
        ProcessInstanceQueryTest.assertEquals((int)5, (int)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionKey().desc()).list().size());
        ProcessInstanceQueryTest.assertEquals((int)4, (int)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).orderByProcessInstanceId().asc()).list().size());
        ProcessInstanceQueryTest.assertEquals((int)4, (int)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).orderByProcessInstanceId().desc()).list().size());
    }

    public void testQueryInvalidSorting() {
        try {
            this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionId().list();
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryStringVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("stringVar2", "ghijkl");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "azerty");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("stringVar", (Object)"abcdef");
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("stringVar2", (Object)"ghijkl");
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("stringVar", (Object)"abcdef").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("stringVar", (Object)"abcdef").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("stringVar", (Object)"z").singleResult();
        Assert.assertNull((Object)resultInstance);
        ProcessInstanceQueryTest.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"abcdef").count());
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"z").count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("stringVar", (Object)"abcdeg").list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        ProcessInstanceQueryTest.assertTrue((boolean)ids.isEmpty());
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("stringVar", (Object)"abcdef").count());
        ProcessInstanceQueryTest.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"abcdef").list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        ProcessInstanceQueryTest.assertTrue((boolean)ids.isEmpty());
        ProcessInstanceQueryTest.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").count());
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"aa").count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "azert%").singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)resultInstance);
        ProcessInstanceQueryTest.assertEquals((String)processInstance3.getId(), (String)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "%y").singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)resultInstance);
        ProcessInstanceQueryTest.assertEquals((String)processInstance3.getId(), (String)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "%zer%").singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)resultInstance);
        ProcessInstanceQueryTest.assertEquals((String)processInstance3.getId(), (String)resultInstance.getId());
        ProcessInstanceQueryTest.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "a%").count());
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "%x%").count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryLongVariable() {
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put("longVar", 12345L);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longVar", 12345L);
        vars.put("longVar2", 67890L);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longVar", 55555L);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("longVar", (Object)12345L);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("longVar", (Object)12345L).variableValueEquals("longVar2", (Object)67890L);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("longVar", (Object)999L).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("longVar", (Object)12345L).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("longVar", (Object)44444L).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("longVar", (Object)55555L).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("longVar", (Object)1L).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("longVar", (Object)44444L).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("longVar", (Object)55555L).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("longVar", (Object)1L).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("longVar", (Object)55555L).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        ProcessInstanceQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("longVar", (Object)12345L).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("longVar", (Object)66666L).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("longVar", (Object)55555L).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("longVar", (Object)12344L).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDoubleVariable() {
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("doubleVar", 12345.6789);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("doubleVar", 12345.6789);
        vars.put("doubleVar2", 9876.54321);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("doubleVar", 55555.5555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("doubleVar", (Object)12345.6789);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("doubleVar", (Object)12345.6789).variableValueEquals("doubleVar2", (Object)9876.54321);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("doubleVar", (Object)9999.99).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("doubleVar", (Object)12345.6789).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("doubleVar", (Object)44444.4444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("doubleVar", (Object)55555.5555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("doubleVar", (Object)1.234).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)44444.4444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)55555.5555).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)1.234).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("doubleVar", (Object)55555.5555).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        ProcessInstanceQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("doubleVar", (Object)12345.6789).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("doubleVar", (Object)66666.6666).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("doubleVar", (Object)55555.5555).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("doubleVar", (Object)12344.6789).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryIntegerVariable() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("integerVar", 12345);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("integerVar", 12345);
        vars.put("integerVar2", 67890);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("integerVar", 55555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("integerVar", (Object)12345);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("integerVar", (Object)12345).variableValueEquals("integerVar2", (Object)67890);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("integerVar", (Object)9999).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("integerVar", (Object)12345).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("integerVar", (Object)44444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("integerVar", (Object)55555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("integerVar", (Object)1).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("integerVar", (Object)44444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("integerVar", (Object)55555).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("integerVar", (Object)1).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("integerVar", (Object)55555).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        ProcessInstanceQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("integerVar", (Object)12345).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("integerVar", (Object)66666).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("integerVar", (Object)55555).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("integerVar", (Object)12344).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryShortVariable() {
        HashMap<String, Short> vars = new HashMap<String, Short>();
        short shortVar = 1234;
        vars.put("shortVar", shortVar);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        short shortVar2 = 6789;
        vars = new HashMap();
        vars.put("shortVar", shortVar);
        vars.put("shortVar2", shortVar2);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("shortVar", (short)5555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("shortVar", (Object)shortVar);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("shortVar", (Object)shortVar).variableValueEquals("shortVar2", (Object)shortVar2);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        short unexistingValue = 9999;
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("shortVar", (Object)unexistingValue).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("shortVar", (Object)1234).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("shortVar", (Object)4444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("shortVar", (Object)5555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("shortVar", (Object)1).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("shortVar", (Object)4444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("shortVar", (Object)5555).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("shortVar", (Object)1).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("shortVar", (Object)5555).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        ProcessInstanceQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("shortVar", (Object)1234).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("shortVar", (Object)6666).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("shortVar", (Object)5555).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("shortVar", (Object)1233).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDateVariable() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        Date date1 = Calendar.getInstance().getTime();
        vars.put("dateVar", date1);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Date date2 = Calendar.getInstance().getTime();
        vars = new HashMap();
        vars.put("dateVar", date1);
        vars.put("dateVar2", date2);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Calendar nextYear = Calendar.getInstance();
        nextYear.add(1, 1);
        vars = new HashMap();
        vars.put("dateVar", nextYear.getTime());
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Calendar nextMonth = Calendar.getInstance();
        nextMonth.add(2, 1);
        Calendar twoYearsLater = Calendar.getInstance();
        twoYearsLater.add(1, 2);
        Calendar oneYearAgo = Calendar.getInstance();
        oneYearAgo.add(1, -1);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("dateVar", (Object)date1);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("dateVar", (Object)date1).variableValueEquals("dateVar2", (Object)date2);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        Date unexistingDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/01/1989 12:00:00");
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("dateVar", (Object)unexistingDate).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("dateVar", (Object)date1).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)nextYear.getTime()).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)oneYearAgo.getTime()).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextYear.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        ProcessInstanceQueryTest.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("dateVar", (Object)date1).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("dateVar", (Object)twoYearsLater.getTime()).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testBooleanVariable() throws Exception {
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("booleanVar", true);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("booleanVar", false);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("booleanVar", (Object)true).list();
        ProcessInstanceQueryTest.assertNotNull((Object)instances);
        ProcessInstanceQueryTest.assertEquals((int)1, (int)instances.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance1.getId(), (String)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("booleanVar", (Object)false).list();
        ProcessInstanceQueryTest.assertNotNull((Object)instances);
        ProcessInstanceQueryTest.assertEquals((int)1, (int)instances.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance2.getId(), (String)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("booleanVar", (Object)true).list();
        ProcessInstanceQueryTest.assertNotNull((Object)instances);
        ProcessInstanceQueryTest.assertEquals((int)1, (int)instances.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance2.getId(), (String)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("booleanVar", (Object)false).list();
        ProcessInstanceQueryTest.assertNotNull((Object)instances);
        ProcessInstanceQueryTest.assertEquals((int)1, (int)instances.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance1.getId(), (String)((ProcessInstance)instances.get(0)).getId());
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("booleanVar", (Object)true);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'greater than' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("booleanVar", (Object)true);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'greater than or equal' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThan("booleanVar", (Object)true);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'less than' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("booleanVar", (Object)true);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'less than or equal' condition", ae.getMessage());
        }
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryVariablesUpdatedToNullValue() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "coca-cola");
        variables.put("dateVar", new Date());
        variables.put("booleanVar", true);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("longVar", null).variableValueEquals("shortVar", null).variableValueEquals("integerVar", null).variableValueEquals("stringVar", null).variableValueEquals("booleanVar", null).variableValueEquals("dateVar", null);
        ProcessInstanceQuery notQuery = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("longVar", null).variableValueNotEquals("shortVar", null).variableValueNotEquals("integerVar", null).variableValueNotEquals("stringVar", null).variableValueNotEquals("booleanVar", null).variableValueNotEquals("dateVar", null);
        ProcessInstanceQueryTest.assertNull((Object)query.singleResult());
        ProcessInstanceQueryTest.assertNotNull((Object)notQuery.singleResult());
        this.runtimeService.setVariable(processInstance.getId(), "longVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "booleanVar", null);
        Execution queryResult = (Execution)query.singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)queryResult);
        ProcessInstanceQueryTest.assertEquals((String)processInstance.getId(), (String)queryResult.getId());
        ProcessInstanceQueryTest.assertNull((Object)notQuery.singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryNullVariable() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("nullVar", null);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVar", "notnull");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarLong", "notnull");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarDouble", "notnull");
        ProcessInstance processInstance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarByte", "testbytes".getBytes());
        ProcessInstance processInstance5 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("nullVar", null);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
        Assert.assertEquals((Object)processInstance1.getId(), (Object)((ProcessInstance)processInstances.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("nullVar", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("nullVarLong", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("nullVarDouble", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("nullVarByte", null).count());
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("nullVar", null);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'greater than' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("nullVar", null);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'greater than or equal' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThan("nullVar", null);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'less than' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("nullVar", null);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'less than or equal' condition", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLike("nullVar", null);
            ProcessInstanceQueryTest.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Booleans and null cannot be used in 'like' condition", ae.getMessage());
        }
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance4.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance5.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryInvalidTypes() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("bytesVar", "test".getBytes());
        vars.put("serializableVar", new DummySerializable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueEquals("bytesVar", (Object)"test".getBytes()).list();
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Variables of type ByteArray cannot be used to query", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueEquals("serializableVar", (Object)new DummySerializable()).list();
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Object values cannot be used to query", ae.getMessage());
        }
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
    }

    public void testQueryVariablesNullNameArgument() {
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueEquals(null, (Object)"value");
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueNotEquals(null, (Object)"value");
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan(null, (Object)"value");
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual(null, (Object)"value");
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThan(null, (Object)"value");
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual(null, (Object)"value");
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLike(null, "value");
            ProcessInstanceQueryTest.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("name is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAllVariableTypes() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("nullVar", null);
        vars.put("stringVar", "string");
        vars.put("longVar", 10L);
        vars.put("doubleVar", 1.2);
        vars.put("integerVar", 1234);
        vars.put("booleanVar", true);
        vars.put("shortVar", (short)123);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("nullVar", null).variableValueEquals("stringVar", (Object)"string").variableValueEquals("longVar", (Object)10L).variableValueEquals("doubleVar", (Object)1.2).variableValueEquals("integerVar", (Object)1234).variableValueEquals("booleanVar", (Object)true).variableValueEquals("shortVar", (Object)123);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)processInstances.get(0)).getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testClashingValues() throws Exception {
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put("var", 1234L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        HashMap<String, Integer> vars2 = new HashMap<String, Integer>();
        vars2.put("var", 1234);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars2);
        List foundInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").variableValueEquals("var", (Object)1234L).list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)foundInstances.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)foundInstances.get(0)).getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
    }

    public void testQueryByProcessInstanceIds() {
        HashSet<String> processInstanceIds = new HashSet<String>(this.processInstanceIds);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess2", "2");
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds);
        ProcessInstanceQueryTest.assertEquals((long)5L, (long)processInstanceQuery.count());
        List processInstances = processInstanceQuery.list();
        ProcessInstanceQueryTest.assertNotNull((Object)processInstances);
        ProcessInstanceQueryTest.assertEquals((int)5, (int)processInstances.size());
        for (ProcessInstance processInstance : processInstances) {
            ProcessInstanceQueryTest.assertTrue((boolean)processInstanceIds.contains(processInstance.getId()));
        }
    }

    public void testQueryByProcessInstanceIdsEmpty() {
        try {
            this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet());
            ProcessInstanceQueryTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("Set of process instance ids is empty", re.getMessage());
        }
    }

    public void testQueryByProcessInstanceIdsNull() {
        try {
            this.runtimeService.createProcessInstanceQuery().processInstanceIds(null);
            ProcessInstanceQueryTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("Set of process instance ids is null", re.getMessage());
        }
    }

    public void testQueryByActive() throws Exception {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertEquals((long)5L, (long)processInstanceQuery.active().count());
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess");
        ProcessInstanceQueryTest.assertEquals((long)5L, (long)processInstanceQuery.active().count());
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)processInstanceQuery.active().count());
    }

    public void testQueryBySuspeded() throws Exception {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)processInstanceQuery.suspended().count());
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess");
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)processInstanceQuery.suspended().count());
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)processInstanceQuery.suspended().count());
    }

    public void testNativeQuery() {
        ProcessInstanceQueryTest.assertEquals((String)"ACT_RU_EXECUTION", (String)this.managementService.getTableName(ProcessInstance.class));
        long piCount = this.runtimeService.createProcessInstanceQuery().count();
        ProcessInstanceQueryTest.assertEquals((long)piCount, (long)((NativeProcessInstanceQuery)this.runtimeService.createNativeProcessInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(ProcessInstance.class))).list().size());
        ProcessInstanceQueryTest.assertEquals((long)piCount, (long)((NativeProcessInstanceQuery)this.runtimeService.createNativeProcessInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(ProcessInstance.class))).count());
    }

    public void testNativeQueryPaging() {
        ProcessInstanceQueryTest.assertEquals((int)5, (int)((NativeProcessInstanceQuery)this.runtimeService.createNativeProcessInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(ProcessInstance.class))).listPage(0, 5).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentId(incident.getId()).list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)processInstanceList.size());
    }

    public void testQueryByInvalidIncidentId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)query.incidentId("invalid").count());
        try {
            query.incidentId(null);
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentType() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentType(incident.getIncidentType()).list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)processInstanceList.size());
    }

    public void testQueryByInvalidIncidentType() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)query.incidentType("invalid").count());
        try {
            query.incidentType(null);
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessage() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentMessage(incident.getIncidentMessage()).list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)processInstanceList.size());
    }

    public void testQueryByInvalidIncidentMessage() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)query.incidentMessage("invalid").count());
        try {
            query.incidentMessage(null);
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageLike() {
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)incidentList.size());
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentMessageLike("%exception%").list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)processInstanceList.size());
    }

    public void testQueryByInvalidIncidentMessageLike() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)query.incidentMessageLike("invalid").count());
        try {
            query.incidentMessageLike(null);
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentIdInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentId(incident.getId()).list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)processInstanceList.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)processInstanceList.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentTypeInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentType(incident.getIncidentType()).list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)processInstanceList.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)processInstanceList.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentMessage(incident.getIncidentMessage()).list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)processInstanceList.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)processInstanceList.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageLikeInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)incidentList.size());
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentMessageLike("%exception%").list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)processInstanceList.size());
        ProcessInstanceQueryTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)processInstanceList.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByCaseInstanceId() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneProcessTaskCase").create().getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        List result = query.list();
        ProcessInstanceQueryTest.assertEquals((int)1, (int)result.size());
        ProcessInstance processInstance = (ProcessInstance)result.get(0);
        ProcessInstanceQueryTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
    }

    public void testQueryByInvalidCaseInstanceId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        query.caseInstanceId("invalid");
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            query.caseInstanceId(null);
            ProcessInstanceQueryTest.fail((String)"The passed case instance should not be null.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/superProcessWithCallActivityInsideSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneProcessTaskCase").businessKey("aBusinessKey").create().getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        ProcessInstanceQueryTest.assertEquals((long)2L, (long)query.count());
        List result = query.list();
        ProcessInstanceQueryTest.assertEquals((int)2, (int)result.size());
        ProcessInstance firstProcessInstance = (ProcessInstance)result.get(0);
        ProcessInstanceQueryTest.assertEquals((String)caseInstanceId, (String)firstProcessInstance.getCaseInstanceId());
        ProcessInstance secondProcessInstance = (ProcessInstance)result.get(1);
        ProcessInstanceQueryTest.assertEquals((String)caseInstanceId, (String)secondProcessInstance.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueNumberComparison() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("var", (Object)Variables.numberValue((Number)123)).count());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("var", (Object)Variables.numberValue((Number)123)).count());
        ProcessInstanceQueryTest.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("var", (Object)Variables.numberValue((Number)123)).count());
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("var", (Object)Variables.numberValue((Number)123)).count());
        ProcessInstanceQueryTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("var", (Object)Variables.numberValue((Number)123)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn"})
    public void testQueryBySuperCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(processTaskId);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().superCaseInstanceId(superCaseInstanceId);
        ProcessInstanceQueryTest.assertEquals((int)1, (int)query.list().size());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        ProcessInstance subProcessInstance = (ProcessInstance)query.singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)subProcessInstance);
    }

    public void testQueryByInvalidSuperCaseInstanceId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertNull((Object)query.superProcessInstanceId("invalid").singleResult());
        ProcessInstanceQueryTest.assertEquals((int)0, (int)query.superProcessInstanceId("invalid").list().size());
        try {
            query.superCaseInstanceId(null);
            ProcessInstanceQueryTest.fail();
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySubCaseInstanceId() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId).singleResult()).getId();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        ProcessInstanceQueryTest.assertEquals((int)1, (int)query.list().size());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        ProcessInstance superProcessInstance = (ProcessInstance)query.singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)superProcessInstance);
        ProcessInstanceQueryTest.assertEquals((String)superProcessInstanceId, (String)superProcessInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivityInsideSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySubCaseInstanceIdNested() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId).singleResult()).getId();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        ProcessInstanceQueryTest.assertEquals((int)1, (int)query.list().size());
        ProcessInstanceQueryTest.assertEquals((long)1L, (long)query.count());
        ProcessInstance superProcessInstance = (ProcessInstance)query.singleResult();
        ProcessInstanceQueryTest.assertNotNull((Object)superProcessInstance);
        ProcessInstanceQueryTest.assertEquals((String)superProcessInstanceId, (String)superProcessInstance.getId());
    }

    public void testQueryByInvalidSubCaseInstanceId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        ProcessInstanceQueryTest.assertNull((Object)query.subProcessInstanceId("invalid").singleResult());
        ProcessInstanceQueryTest.assertEquals((int)0, (int)query.subProcessInstanceId("invalid").list().size());
        try {
            query.subCaseInstanceId(null);
            ProcessInstanceQueryTest.fail();
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryNullValue() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("var", (TypedValue)Variables.stringValue(null)));
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("var", null));
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a String Value"));
        ProcessInstance processInstance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"another String Value"));
        List instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", null).list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance1.getId(), processInstance2.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("var", null).list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance3.getId(), processInstance4.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.stringValue(null)).list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance1.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("var", (Object)Variables.stringValue(null)).list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance2.getId(), processInstance3.getId(), processInstance4.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)"a String Value").list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance3.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("var", (Object)"a String Value").list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance1.getId(), processInstance2.getId(), processInstance4.getId()));
    }

    public void testQueryByDeploymentId() {
        String firstDeploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        org.camunda.bpm.engine.repository.Deployment secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml").deploy();
        ProcessInstance secondProcessInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().deploymentId(firstDeploymentId);
        ProcessInstanceQueryTest.assertEquals((long)5L, (long)query.count());
        List instances = query.list();
        ProcessInstanceQueryTest.assertEquals((int)5, (int)instances.size());
        for (ProcessInstance returnedInstance : instances) {
            ProcessInstanceQueryTest.assertTrue((!returnedInstance.getId().equals(secondProcessInstance.getId()) ? 1 : 0) != 0);
        }
        this.repositoryService.deleteDeployment(secondDeployment.getId(), true);
    }

    public void testQueryByInvalidDeploymentId() {
        ProcessInstanceQueryTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().deploymentId("invalid").count());
        try {
            this.runtimeService.createProcessInstanceQuery().deploymentId(null).count();
            ProcessInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    protected <T> Set<T> asSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    protected void verifyResultContainsExactly(List<ProcessInstance> instances, Set<String> processInstanceIds) {
        HashSet<String> retrievedInstanceIds = new HashSet<String>();
        for (ProcessInstance instance : instances) {
            retrievedInstanceIds.add(instance.getId());
        }
        ProcessInstanceQueryTest.assertEquals(processInstanceIds, retrievedInstanceIds);
    }
}

