/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import java.util.Arrays;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.authorization.MyResourceAuthorizationProvider;

public class ResourceAuthorizationProviderTest
extends ResourceProcessEngineTestCase {
    protected String userId = "test";
    protected String groupId = "accounting";
    protected User user;
    protected Group group;

    public ResourceAuthorizationProviderTest() {
        super("org/camunda/bpm/engine/test/authorization/resource.authorization.provider.camunda.cfg.xml");
    }

    protected void initializeProcessEngine() {
        super.initializeProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        this.processEngineConfiguration.setResourceAuthorizationProvider((ResourceAuthorizationProvider)new MyResourceAuthorizationProvider());
        this.identityService = this.processEngineConfiguration.getIdentityService();
        this.authorizationService = this.processEngineConfiguration.getAuthorizationService();
        this.user = this.createUser(this.userId);
        this.group = this.createGroup(this.groupId);
        this.identityService.createMembership(this.userId, this.groupId);
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    public void testNewTaskAssignee() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.setAssignee(taskId, "demo");
        ResourceAuthorizationProviderTest.assertNull((Object)MyResourceAuthorizationProvider.OLD_ASSIGNEE);
        ResourceAuthorizationProviderTest.assertEquals((String)"demo", (String)MyResourceAuthorizationProvider.NEW_ASSIGNEE);
        MyResourceAuthorizationProvider.clearProperties();
        this.taskService.setAssignee(taskId, this.userId);
        ResourceAuthorizationProviderTest.assertEquals((String)"demo", (String)MyResourceAuthorizationProvider.OLD_ASSIGNEE);
        ResourceAuthorizationProviderTest.assertEquals((String)this.userId, (String)MyResourceAuthorizationProvider.NEW_ASSIGNEE);
        this.taskService.deleteTask(taskId, true);
    }

    public void testNewTaskOwner() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.setOwner(taskId, "demo");
        ResourceAuthorizationProviderTest.assertNull((Object)MyResourceAuthorizationProvider.OLD_OWNER);
        ResourceAuthorizationProviderTest.assertEquals((String)"demo", (String)MyResourceAuthorizationProvider.NEW_OWNER);
        MyResourceAuthorizationProvider.clearProperties();
        this.taskService.setOwner(taskId, this.userId);
        ResourceAuthorizationProviderTest.assertEquals((String)"demo", (String)MyResourceAuthorizationProvider.OLD_OWNER);
        ResourceAuthorizationProviderTest.assertEquals((String)this.userId, (String)MyResourceAuthorizationProvider.NEW_OWNER);
        this.taskService.deleteTask(taskId, true);
    }

    public void testAddCandidateUser() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addCandidateUser(taskId, "demo");
        ResourceAuthorizationProviderTest.assertEquals((String)"candidate", (String)MyResourceAuthorizationProvider.ADD_USER_IDENTITY_LINK_TYPE);
        ResourceAuthorizationProviderTest.assertEquals((String)"demo", (String)MyResourceAuthorizationProvider.ADD_USER_IDENTITY_LINK_USER);
        this.taskService.deleteTask(taskId, true);
    }

    public void testAddUserIdentityLink() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addUserIdentityLink(taskId, "demo", "myIdentityLink");
        ResourceAuthorizationProviderTest.assertEquals((String)"myIdentityLink", (String)MyResourceAuthorizationProvider.ADD_USER_IDENTITY_LINK_TYPE);
        ResourceAuthorizationProviderTest.assertEquals((String)"demo", (String)MyResourceAuthorizationProvider.ADD_USER_IDENTITY_LINK_USER);
        this.taskService.deleteTask(taskId, true);
    }

    public void testAddCandidateGroup() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addCandidateGroup(taskId, "management");
        ResourceAuthorizationProviderTest.assertEquals((String)"candidate", (String)MyResourceAuthorizationProvider.ADD_GROUP_IDENTITY_LINK_TYPE);
        ResourceAuthorizationProviderTest.assertEquals((String)"management", (String)MyResourceAuthorizationProvider.ADD_GROUP_IDENTITY_LINK_GROUP);
        this.taskService.deleteTask(taskId, true);
    }

    public void testAddGroupIdentityLink() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addGroupIdentityLink(taskId, "management", "myIdentityLink");
        ResourceAuthorizationProviderTest.assertEquals((String)"myIdentityLink", (String)MyResourceAuthorizationProvider.ADD_GROUP_IDENTITY_LINK_TYPE);
        ResourceAuthorizationProviderTest.assertEquals((String)"management", (String)MyResourceAuthorizationProvider.ADD_GROUP_IDENTITY_LINK_GROUP);
        this.taskService.deleteTask(taskId, true);
    }

    public void testDeleteUserIdentityLink() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addCandidateUser(taskId, "demo");
        this.taskService.deleteCandidateUser(taskId, "demo");
        ResourceAuthorizationProviderTest.assertEquals((String)"candidate", (String)MyResourceAuthorizationProvider.DELETE_USER_IDENTITY_LINK_TYPE);
        ResourceAuthorizationProviderTest.assertEquals((String)"demo", (String)MyResourceAuthorizationProvider.DELETE_USER_IDENTITY_LINK_USER);
        this.taskService.deleteTask(taskId, true);
    }

    public void testDeleteGroupIdentityLink() {
        MyResourceAuthorizationProvider.clearProperties();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", (Permission)Permissions.ALL, this.userId);
        String taskId = "myTask";
        Task newTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(newTask);
        this.taskService.addCandidateGroup(taskId, "management");
        this.taskService.deleteCandidateGroup(taskId, "management");
        ResourceAuthorizationProviderTest.assertEquals((String)"candidate", (String)MyResourceAuthorizationProvider.DELETE_GROUP_IDENTITY_LINK_TYPE);
        ResourceAuthorizationProviderTest.assertEquals((String)"management", (String)MyResourceAuthorizationProvider.DELETE_GROUP_IDENTITY_LINK_GROUP);
        this.taskService.deleteTask(taskId, true);
    }

    protected User createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.AUTHORIZATION, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        authorization = this.createGrantAuthorization((Resource)Resources.USER, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        return user;
    }

    protected Group createGroup(String groupId) {
        Group group = this.identityService.newGroup(groupId);
        this.identityService.saveGroup(group);
        return group;
    }

    protected void createGrantAuthorization(Resource resource, String resourceId, Permission permission, String userId) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setUserId(userId);
        authorization.addPermission(permission);
        this.saveAuthorization(authorization);
    }

    protected Authorization createGrantAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(1, resource, resourceId);
        return authorization;
    }

    protected Authorization createAuthorization(int type, Resource resource, String resourceId) {
        Authorization authorization = this.authorizationService.createNewAuthorization(type);
        authorization.setResource(resource);
        if (resourceId != null) {
            authorization.setResourceId(resourceId);
        }
        return authorization;
    }

    protected void saveAuthorization(Authorization authorization) {
        this.authorizationService.saveAuthorization(authorization);
    }
}

