/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.dmn;

import java.io.InputStream;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;
import org.camunda.bpm.model.dmn.DmnModelInstance;

public class DecisionDefinitionAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "testProcess";
    protected static final String DECISION_DEFINITION_KEY = "sampleDecision";

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/authorization/singleDecision.dmn11.xml", "org/camunda/bpm/engine/test/authorization/anotherDecision.dmn11.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryWithoutAuthorization() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    public void testQueryWithReadPermissionOnAnyDecisionDefinition() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    public void testQueryWithReadPermissionOnOneDecisionDefinition() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        DecisionDefinition definition = (DecisionDefinition)query.singleResult();
        DecisionDefinitionAuthorizationTest.assertNotNull((Object)definition);
        DecisionDefinitionAuthorizationTest.assertEquals((String)DECISION_DEFINITION_KEY, (String)definition.getKey());
    }

    public void testGetDecisionDefinitionWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.getDecisionDefinition(decisionDefinitionId);
            DecisionDefinitionAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }

    public void testGetDecisionDefinition() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        DecisionDefinition decisionDefinition = this.repositoryService.getDecisionDefinition(decisionDefinitionId);
        DecisionDefinitionAuthorizationTest.assertNotNull((Object)decisionDefinition);
    }

    public void testGetDecisionDiagramWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.getDecisionDiagram(decisionDefinitionId);
            DecisionDefinitionAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }

    public void testGetDecisionDiagram() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getDecisionDiagram(decisionDefinitionId);
        DecisionDefinitionAuthorizationTest.assertNull((Object)stream);
    }

    public void testGetDecisionModelWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.getDecisionModel(decisionDefinitionId);
            DecisionDefinitionAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }

    public void testGetDecisionModel() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getDecisionModel(decisionDefinitionId);
        DecisionDefinitionAuthorizationTest.assertNotNull((Object)stream);
    }

    public void testGetDmnModelInstanceWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.getDmnModelInstance(decisionDefinitionId);
            DecisionDefinitionAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }

    public void testGetDmnModelInstance() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        DmnModelInstance modelInstance = this.repositoryService.getDmnModelInstance(decisionDefinitionId);
        DecisionDefinitionAuthorizationTest.assertNotNull((Object)modelInstance);
    }
}

