/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.externaltask;

import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.authorization.util.AuthorizationTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompleteExternalTaskAuthorizationTest {
    public ProcessEngineRule engineRule = new ProcessEngineRule(PluggableProcessEngineTestCase.getProcessEngine(), true);
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstanceId", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstanceId", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteExternalTask() {
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.engineRule.getExternalTaskService().fetchAndLock(5, "workerId").topic("externalTaskTopic", 5000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstance.getId()).bindResource("processDefinitionKey", "oneExternalTaskProcess").start();
        this.engineRule.getExternalTaskService().complete(task.getId(), "workerId");
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getExternalTaskService().createExternalTaskQuery().count());
        }
    }
}

